; formulas accessed from my PARS, lumped in here for convenience.
; Sources are noted ... thanks, folks 
; 
; >>don CIS:76704,41

; from SKINNER.FRM - Lee Skinner


 comment { version 15.1:}
 OldNewtonSinExp (XAXIS) {; Chris Green
  ; Newton's formula applied to sin(x)+exp(x)-1=0.
  ; Use floating point.
  z=pixel:
   z1=exp(z)
   z2=sin(z)+z1-1
   z=z-p1*z2/(cosxx(z)+z1),
    .0001 < |z2|
  }

comment { version 15.1:}
 OldCGNewtonSinExp (XAXIS) {
        z=pixel:
        z1=exp(z);
        z2=sin(z)+z1-z;
        z=z-p1*z2/(cosxx(z)+z1), .0001 < |z2|
   }

OldManowar (XAXIS) {
           z0 = 0,
           z1 = 0,
         test = p1 + 3,
           c = pixel :
               z = z1*z1 + z0 + c;
               z0 = z1;
               z1 = z,  |z| < test }

CGNewtonSinExp (XAXIS) {
        z=pixel:
        z1=exp(z);
        z2=sin(z)+z1-z;
        z=z-p1*z2/(cos(z)+z1), .0001 < |z2|
   }
   
Leeze (XAXIS) = {
                       s = exp(1.,0.), z = Pixel, f = Pixel ^ s:
                       z = cosxx (z) + f, |z| <= 50 }

FractalFenderC(XAXIS_NOPARM) {
                       z=p1,x=|z|:
                       (z=cosh(z)+pixel)*(1<x)+(z=z)*(x<=1),
                       z=sqr(z)+pixel,x=|z|,
                       x<=4 }

TSinh (XAXIS) = {
        z = c = sinh(pixel):
        z = c ^ z,
        z <= (p1 + 3)
        }

ScSkLMS(XAXIS) { z = pixel, TEST = (p1+3): z = log(z) - sin(z), |z|<TEST }
;
ScSkZCZZ(XYAXIS) { z = pixel, TEST = (p1+3): z = (z*cosxx(z)) - z, |z|<TEST }
;

;REB004.FRM - Ron Barnett

REB004A = {; Ron Barnett, 1993
   z = pixel:
   z =p1*fn1(z) + p1*p1*fn2(p2*z) + pixel, |z| <= 100
   }

REB004M = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1(const - 12*x)*x/(4*const);
   y1 = -fn2(const + 12*x)*y/(4*const);
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x*y;
   z = x2 + flip(y2), |z| <= 100
   } 
;

;
; REB002.FRM                                     
; Ron Barnett 70153,1233                         

FlipLambdaJ = { ; Ron Barnett, 1993
   z = pixel:
   z = p1*z*(1-flip(z)*flip(z)), |z| <= 100
   }

; REB005.FRM                                     
; Ron Barnett 70153,1233                         
REB005E = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1((const - x)*x/const);
   y1 = -fn2((const + y)*y/const);
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   }

REB005F = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1((const - 12*x)*x/(4*const));
   y1 = -fn2((const + 12*y)*y/(4*const));
   x2 = x1*x1 - y1*y1 + p1;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   } 

REB005G = {; Ron Barnett, 1993
              ; floating point required
   z = pixel:
   x = real(z), y = imag(z);
   const = x*x + y*y;
   x1 = -fn1(const + p1*x)*y/const;
   y1 = -fn2(const + y)*x/const;
   x2 = x1*x1 - y1*y1 + p2;
   y2 = 2*x1*y1;
   z = x2 + flip(y2), |z| <= 100
   }
       



;LIAR.FRM - Chuck Ebbert

Liar3 { ; by Chuck Ebbert.
        ; X: X is true to P1 times the extent that Y is true
        ; Y: Y is true to the extent that X is false.
        ; Sequential reasoning.  P1 usually 0 to 1.  P1=1 is Liar2 formula.
        ; x(n+1) = 1 - abs(p1*y(n)-x(n) );
        ; y(n+1) = 1 - abs((1-x(n+1) )-y(n) );
   z = pixel:
   x = 1 - abs(imag(z)*real(p1)-real(z) )
   z = flip(1 - abs(1-real(x)-imag(z) ) ) + real(x)
  |z| <= 1;
}


Liar4 { ; by Chuck Ebbert.
        ; X: X is as true as (p1+1) times Y
        ; Y: Y is as true as X is false
        ; Calculate new x and y values simultaneously.
        ; Real part of p1 changes probability.  Use floating point.
        ; y(n+1)=abs((1-x(n) )-y(n) ), x(n+1)=1-abs(y(n)-x(n) )
  z = pixel, p = p1 + 1:
   z = 1-abs(imag(z)*p-real(z))+flip(1-abs(1-real(z)-imag(z)));
    |z| <= 1
    }

;Tim Wegner - from a message on the board in GraphDev 1/10/94

Newton_poly2 { ; Tim Wegner - use float=yes
   ; fractal generated by Newton formula z^3 + (c-1)z - c
   ; p1 is c in above formula
   z = pixel, z2 = z*z, z3 = z*z2:
   z = (2*z3 + p1) / (3*z2 + (p1 - 1));
   z2 = z*z;
   z3 = z*z2,
  .004 <= |z3 + (p1-1)*z - p1|
  }

; and another one from 7/94

Newt_ellipt_oops { ; Tim Wegner - use float=yes and periodicity=0
   ; fractal generated by Newton formula  (z^3 + c*z^2 +1)^.5
   ; try p1 = 1 and p2 = .1
   ; if p2 is small (say .001), converges very slowly so need large maxit
   ; another "tim's error" - mistook sqr for sqrt (see next)
   z = pixel, z2 = z*z, z3 = z*z2:
   num = (z3 + p1*z2 + 1)^.5      ; f(z)
   denom = (1.5*z2 + p1*z)/num    ; f'(z)
   z = z - (num/denom)            ; z - f(z)/f'(z)
   z2 = z*z
   z3 = z*z2,
   p2 <= |z3 + p1*z2 + 1|         ; no need for sqrt because sqrt(z)==0 iff z==0
  }

Newton_elliptic { ; Tim Wegner - use float=yes and periodicity=0
   ; fractal generated by Newton formula f(z) = (z^3 + c*z^2 +1)^2
   ; try p1 = 1 and p2 = .0001
   z = pixel, z2 = z*z, z3 = z*z2:
   z = z - (z3 + p1*z2 + 1)/(6*z2 + 4*p1*z)      ; z - f(z)/f'(z)
   z2 = z*z
   z3 = z*z2,
   p2 <= |z3 + p1*z2 + 1|  ; no need for sqr because sqr(z)==0 iff z==0
  }

comment {the following forumlas are from OVERKILL.FRM, by Bradley Beacham
         CIS: 74223,2745  Internet 74223.2745@compuserve.com}

OK-11 { ;overkill.frm - bradley beacham
        ;TRY FN1 = SQR, FN2 = SQR
   z = 0, v = pixel:
   z = fn1(v) + z;
   v = fn2(z) + v,
   |z| <= (5 + p1)
  }

OK-13 { ;overkill.frm - bradley beacham
        ;TRY FN1 = SQR, FN2 = SQR
   z = 0, c = fn1(pixel) :
   z = fn1(z) + c;
   z = fn2(z),
   |z| <= (5 + p1)
  }

OK-21 {;overkill.frm - bradley beacham
   z = pixel, c = fn1(pixel):
   z = fn2(z) + c,
   fn3(z) <= p1
  }

OK-23 {;overkill.frm - bradley beacham
   
   z = c = pixel, k = 1 + p1:
   z = k * fn1(z^z + c) + c/z,
   |z| <= (5 + p2)
  }

OK-26 {;overkill.frm - bradley beacham
  
   z = c = pixel, k = 2 + p1, test = k/(2 + p2):
   a = fn1(z);
   b = (|z| > test)  * (a - c);
   d = (|z| <= test) * (a + c);
   z = b + d,
   |z| <= k
  }

OK-27 {;overkill.frm - bradley beacham

   z = pixel, c = fn1(pixel), k = 1 + p1:
   a = fn2(z);
   b = (|z| >= k) * (a - c);
   d = (|z| < k) * (a + c);
   z = a + b + d,
   |z| <= (10 + p2)
  }

OK-30 {;overkill.frm - bradley beacham
 
   z = v = pixel, k = .5 + p1:
   a = fn1(z);
   b = (z <= k) * (a + v);
   e = (z > k) * (a - v);
   v = z;
   z = b + e,
   |z| <= (5 + p2)
  }

OK-31 {;overkill.frm - bradley beacham

   z = v = pixel, k = .1 + p1:
   a = fn1(z);
   b = (a <= k) * (a + v);
   e = (a > k) * fn2(a);
   v = z;
   z = b + e,
   |z| <= (5 + p2)
  }

OK-36 { ; DISECTED MANDELBROT
  ; TO GENERATE "STANDARD" MANDELBROT, SET P1 = 0,0 & ALL FN = IDENT
  z = pixel, cx = fn1(real(z)), cy = fn2(imag(z)), k = 2 + p1:
  zx = real(z), zy = imag(z);
  x = fn3(zx*zx - zy*zy) + cx;
  y = fn4(k * zx * zy) + cy;
  z = x + flip(y),
  |z| <  (10 + p2)
}

OK-40 { ; DISECTED OK-39
  ; (ASSUMING YOU USE OK-39 WITH FN1= IDENT & FN2 = SQR...)
  z = pixel, cx = fn1(real(pixel)), cy = fn2(imag(pixel)), k = 2 + p1:
  zx = real(z), zy = imag(z);
  a = zx*cx - zy*cy;
  b = cx*zy + zx*cy;
  x = fn3(a*a - b*b) + cx;
  y = fn4(k*a*b) + cy;
  z = x + flip(y),
  |z| <= (10 + p2)
 }

OK-42 { ;overkill.frm - bradley beacham
        ; MUTATION OF FN + FN
  z = pixel, p1x = real(p1)+1, p1y = imag(p1)+1,
  p2x = real(p2)+1, p2y = imag(p2)+1:
  zx = real(z), zy = imag(z);
  x = fn1(zx*p1x - zy*p1y) + fn2(zx*p2x - zy*p2y);
  y = fn3(zx*p1y + zy*p1x) + fn4(zx*p2y + zy*p2x);
  z = x + flip(y),
  |z| <= 20
}

OK-43 { ;overkill.frm - bradley beacham
        ; DISECTED SPIDER
        ; TO GENERATE "STANDARD" SPIDER, SET P1 = 0,0 & ALL FN = IDENT
  z = c = pixel, k = 2 + p1:
  zx = real(z), zy = imag(z);
  cx = real(c), cy = imag(c);
  x = fn1(zx*zx - zy*zy) + cx;
  y = fn2(k*zx*zy) + cy;
  z = x + flip(y);
  c = fn3((cx + flip(cy))/k) + z,
  |z| <  (10 + p2)
}


comment {more from Brad Beacham ... FUBAR.FRM}

Curly { ; Mutation of 'Natura'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Michael Theroux [71673,2767]
  ; For 'Natura', set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 = Parameter (default 0.5,0), real(p2) = Bailout (default 4)
  z = pixel
  ; The next line sets c=default if p1=0, else c=p1
  c = ((0.5,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    z = fn1(fn2(z*z*z)) + c
    |z| <= test
}

Moe { ; Mutation of 'Zexpe'.  Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Lee Skinner [75450,3631]
  ; For 'Zexpe', set FN1 & FN2 =IDENT and P1 = default
  ; real(p1) = Bailout (default 100)
  s = exp(1.,0.), z = pixel, c = fn1(pixel)
  ; The next line sets test=100 if real(p1)<=0, else test=real(p1)
  test = (100 * (real(p1)<=0) + real(p1) * (0<p1)):
    z = fn2(z)^s + c
    |z| <= test
}

Harpo { ; Mutation of 'Gopalsamy3'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Ron Barnett [70153,1233]
  ; For 'Gopalsamy3' with Ron's suggested parameters,
  ; set FN1 & FN2 = IDENT and P1 & P2 = default
  ; p1 = Parameter (default 1.099,0), real(p2) = Bailout (default 4)
  z = pixel
  ; The next line sets c=default if p1=0, else c=p1
  c = ((1.099,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    x = real(z), y = imag(z)
    x1 = fn1(3*x*y*y - x*x*x) + c
    y = fn2(y*y*y - 3*x*x*y)
    z = x1 + flip(y)
    |z| <= test
}

Groucho { ; Mutation of 'Fish2'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Dave Oliver via Tim Wegner
  ; For 'Fish2', set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 = Parameter (default 1,0), real(p2) = Bailout (default 4)
  z = c = pixel
  ; The next line sets k=default if p1=0, else k=p1
  k = ((1,0) * (|p1|<=0) + p1)
  ; The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2)):
    z1 = c^(fn1(z)-k)
    z = fn2(((c*z1)-k)*(z1))
    |z| <= test
}

Chico { ; Mutation of 'M-SetInNewton'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Jon Horner [100112,1700]
  ; For 'M-SetInNewton' set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 & p2 = Parameters (default 3,0 and 0,0)
  z = 0,  c = fn1(pixel),  cminusone = c-1
  ; The next line sets k=default if p1=0, else k=p1
  k = (3 * (|p1|<=0) + p1)
  kminusone = k - 1:
    oldz = z
    nm = k*c-kminusone*z*cminusone
    dn = k*(k*z*z+cminusone)
    z = fn2(nm/dn)+kminusone*z/k + p2
    0.01 <= |(z-oldz)|
}

Zeppo { ; Mutation of 'Liar4'. Mutated by Bradley Beacham [74223,2745]
  ; Original formula by Chuck Ebbert [76306,1226]
  ; For 'Liar4' set FN1 & FN2 =IDENT and P1 & P2 = default
  ; p1 & p2 = Parameters (default 1,0 and 0,0)
  z = pixel
  ; The next line sets p=default if p1=0, else p=p1
  p = (1 * (|p1|<=0) + p1):
    z =fn1(1-abs(imag(z)*p-real(z)))+flip(fn2(1-abs(1-real(z)-imag(z))))-p2
    |z| <= 1
}

comment {and yet more from Brad. So much fun it should be illegal}

 inandout01 { ;Bradley Beacham  [74223,2745]
  ;p1 = Parameter (default 0), real(p2) = Bailout (default 4)
  ;The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2))
  z = oldz = pixel, c1 = fn1(pixel), c2 = fn2(pixel):
    a = (|z| <= |oldz|) * (c1) ;IN
    b = (|oldz| < |z|)  * (c2) ;OUT
    oldz = z
    z = fn3(z*z) + a + b + p1
    |z| <= test
}

inandout02 { ;Bradley Beacham  [74223,2745]
  ;p1 = Parameter (default 0), real(p2) = Bailout (default 4)
  ;The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2))
  z = oldz = pixel:
    a = (|z| <= |oldz|) * (fn1(z)) ;IN
    b = (|oldz| < |z|) * (fn2(z))  ;OUT
    oldz = z
    z = a + b + p1
    |z| <= test
}
inandout04 { ;Bradley Beacham  [74223,2745]
  ;p1 = Parameter (default 1), real(p2) = Bailout (default 4)
  ;The next line sets k=default if p1=0, else k=p1
  k = ((1) * (|p1|<=0) + p1)
  ;The next line sets test=4 if real(p2)<=0, else test=real(p2)
  test = (4 * (real(p2)<=0) + real(p2) * (0<p2))
  z = oldz = c = pixel:
    a = (|z| <= |oldz|) * (c)   ;IN
    b = (|oldz| < |z|)  * (c*k) ;OUT
    c = a + b
    oldz = z
    z = fn1(z*z) + c
    |z| <= test
}

inandout13 { ;Bradley Beacham  [74223,2745]
  ;p1 = Parameter (default 0), p2 = parameter (default 1,0)
  ;The next line sets k=1 if real(p2)==0, else k=p2
  k = (1 * (real(p2)==0) + p2 * (0 != p2))
  z = c = pixel, rt = real(p1), it = imag(p1), olddist = 100:
    x = real(z) - rt
    y = imag(z) - it
    dist = x*x + y*y
    in  = c * (dist <= olddist)
    out = (z*k) * (olddist < dist)
    c = fn1(in + out)
    olddist = dist
    z = fn2(z*z) + c
      |z| <= 4
}

comment {from 4DFRACT.FRM, Gordon Lamb (CIS: 100272,3541) ... astounding
 stuff}

SJMAND05 {;Mandelbrot lambda function
        z=real(pixel)+flip(imag(pixel)*p1),
        c=p2+p1*real(pixel)+flip(imag(pixel)):
        z=fn1(z)*c, |z|<=64}

comment { Jm Collard-Richard - JMCR1.FRM}


FlipConjJul_N  { ; Jm Collard-Richard
      z=pixel:
      z=flip(conj(z^p2))+p1,
      |z|<=4         }

GenInvMand1_N  { ; Jm Collard-Richard
c=z=1/pixel:
z=fn1(z)*fn2(z)+fn3(fn4(c)),
|z|<=4         }

;JMCR2.FRM

SPCZ(xaxis) { ; resol. sin(z)^cos(z)=0 -Jm Collard-Richard - Use Float=yes
z=pixel:
s=sin(z);
c=cos(z);
co=cotan(z);
sc=s^c;
z1=sc;
z2=((c*co)-(s*log(s)))*sc;
z=z-(z1/z2) ,
0.001<=|z1| }

; don archer, from a message in graphdev 12/94
dafrm21 { ; Copy this formula to formulafile da.frm
   z = pixel:
   x = real(z), y = imag(z),
   x1 = -fn1((x*x*x + y*y*y - 1) - 6*x)*x/(2*x*x*x + y*y*y - 1),
   y1 = -fn2((x*x*x + y*y*y - 1) + 6*x)*y/(2*x*x*x + y*y*y - 1),
   x2 = x1*x1*x1 - y1*y1*y1 + p1 + 5,
   y2 = 4*x*y - 18,
   z = x2 + flip(y2),
   |z| <= 100
   }

