;                                 Nodeview 1.4
;                         Nodelist Door Configuration
;
;
;                Any text following a semi-colon (;) are ignored.
;   The semi-colons are comment markers.  Remove them to activate option.
;                Please see Nodeview.doc for coommand line parameters.
;------------------------------------------------------------------------------
;
;Sysopfirst  Specifies the first name of the sysop as it will be shown to
;            the users.
;
SYSOPFIRST John
;------------------------------------------------------------------------------
;
;SysopLast   Specifies the last name of the sysop as it will be shown to
;            the users.
SYSOPLAST Doe
;------------------------------------------------------------------------------
;
;  BBSName   Specifies the name of the bbs as it will be shown to users.
;
BBSNAME The Unknown BBS
;------------------------------------------------------------------------------
;
;Mono        Will disable color on the local side. (Necessary if you are
;            running a monochrome system)
;
;------------------------------------------------------------------------------
;
;BBSType     Specifies the type of bbs software under which this door program
;            will be run. Valid bbs types include:
;
;       ::::------- Put your bbs type here! Select from those listed above
;       ::::
;       \/\/
BBSTYPE DOORSYS
;                  DOORSYS - The DOOR.SYS format (Wildcat! 3.xx, TAG, etc)
;                     RBBS - Rbbs version 16.1+  (uses DORINFOx.DEF*)
;                    QUICK - Quickbbs,Force,R.A. (uses DORINFOx.DEF**)
;                    PCB12 - Pcboard version 12 (note: see COMPORT note below)
;                    PCB14 - Pcboard version 14
;                    PCB15 - Pcboard version 15
;                  PHOENIX - Phoenix bbs
;                 SPITFIRE - Spitfires drop file (SFDOORS.DAT)
;                     WWIV - WWIV bbs (uses chain.txt)
;                 CALLINFO - Old Wildcat 2.xx
;
;  Notes: There are at least two different types of DORINFOx.DEF
;           *  ANSI graphics is selected when a "2" is passed in the graphics
;              parameter of the DORINFOx.DEF.   RBBS standard.
;          **  ANSI graphics is selected when a "1" is passed in the graphics
;              parameter of the DORINFOx.DEF.   QuickBBS,Remote Access,FORCE,
;              UltraBBS and many shareware BBSes require this type.
;------------------------------------------------------------------------------
;
;ComPort     For bbs types that do not have the com-port contained in their
;            door information files (such as PCBOARD-12), you will have to
;            specify the com-port. Simply put the port number (i.e. 1,2,etc)
;            not the whole word COM1.  If you find that one node locks up
;            another node you may have to use this option.
;            [NOTE: You can also specify the comport using /Cx from the
;            command line]
;
;                   If you are using a bbs type that doesn't provide the com
;        ::-------- port num in it's door information file (such as pcb-12),
;        \/         then uncomment this line and put your com port here.
;COMPORT 1
;
;------------------------------------------------------------------------------
;
;Fossil      Selecting this option will cause doordriver to use a fossil port
;            driver.  Otherwise doordriver will use its own internal comport
;            handlers.  Note - do not use both fossil and Xfossil at the same
;            time. Maximum ANSI standard speed of 38,400.
;
;            Uncomment the next line if you use a fossil device driver with 
;            speeds up to 38,400 baud.
;   ::------
;   ::      
;   \/      
;FOSSIL     
;
;------------------------------------------------------------------------------
;
;Xfossil   Selecting this option will cause NODEVIEW to use the extended fossil
;          driver speeds in both X00 or BNU.   This will support speeds of
;          57,800 or higher baud.  Otherwise DDPlus will use its own internal
;          comport handlers.  This option neither open or closes the fossil
;          but reads and writes to it in whatever state it is when the door
;          is run.
;
;   ::------ Uncomment the next line if you use a fossil device driver using 
;   ::       extended speeds above 38,400 baud.
;   \/   
XFOSSIL
;
;------------------------------------------------------------------------------
;
;LockBaud    This will specify a locked baud rate. If you specify this
;            parameter, then no matter what the bbs software says, this
;            baud rate will be used. [NOTE: You can also specify the locked
;            baud rate using /Bxxxx from the command line]
;
;           ::------If you are locking ports uncomment this line and set this
;           ::      number to the port speed.
;           \/
LOCKBAUD 57600
;
;------------------------------------------------------------------------------
;
;Port1       If you must use a non-standard interrupt, doordriver can be
;Port2       configured for IRQs 0-15. The port# indicates the chosen comport
;Port3       Follow this with the port address in hex.  Afterward put the IRQ
;Port4       in decimal.  For an example if comport 3 at irq 15 and address
;            $03E8 was needed use the following:
;            PORT3 03E8 15
;
;       ::------------ If you are going to use a non-standard IRQ place the
;       ::             port address in hex one space after the PORT# option.
;       ::
;       ::  ::-------- If you have a non-standard IRQ position the IRQ number
;       \/  \/         one space after the ports' hex address.
;PORT1 03F8 4
;PORT2 02F8 3
;PORT3 03E8 4
;PORT4 02E8 3
;
;------------------------------------------------------------------------------
;
;Maxtime     The maxtime parameter will allow you to specify a maximum time
;            per session that a user may be in the door. (i.e. if you
;            specified 30 minutes, then if the user had 60 mins left, he could
;            only play for 30 mins)
;
;------------------------------------------------------------------------------;;
;Status      Specify "ON" if you wish the status line to appear at the bottom
;            or "OFF" if you wish it to be disabled.
;
;------------------------------------------------------------------------------
;
;Statfore    Statfore foreground color of the status line and the major input
;            fields. (default 0  Black)
;
Statfore 0
;
;------------------------------------------------------------------------------
;
;Statback    The background color of the status line (default 7 white)
;
Statback 7
;
;------------------------------------------------------------------------------
; NODEVIEW Menu Colors (OPTIONAL)
;
; All options below tell NODEVIEW to change the color of the perspective
; entry.  Remember these entries are directly effected by the ANSI files
; in the NODEVIEW directory.  If you want to change the whole look then you
; will have to also change the ANSI files with your favorite Ansi editor and
; save them as an 80 x 20 line Ansi file (See Nodeview.Doc file).
;
Main Menu Cursor Color 1
Main Menu Cursor Background 0
Main Menu BracketColor 8
Main Menu Foreground 0
Main Menu Background 7
;
Nodelist Menu Cursor Color 5
Nodelist Menu Cursor Background 0
Nodelist Menu BracketColor 8
Nodelist Menu Foreground 0
Nodelist Menu Background 7
;
Download Menu Cursor Color 3
Download Menu Cursor Background 0
Download Menu BracketColor 8
Download Menu Foreground 0
Download Menu Background 7

;------------------------------------------------------------------------------
; Color1
;            Tells NODEVIEW to select ANSI graphics when a "1" is passed
;            in the graphics parameter of the DORINFOx.DEF. From what I
;            understand, FORCE and QUICKBBS require this option set although
;            RBBS should not.
;------------------------------------------------------------------------------
;
;CUSTOMMENU
;            If Uncommented then Menu Cursor Control is disabled completely
;            allowing you to make your own screens without having to worry
;            about the Menu selector lining up..
;
;------------------------------------------------------------------------------

;            If DISPLAY MENUCHOICES = NO  then the Display of Menu Choices
;            are disabled allowing you to make your own screens without
;            having to worry about the Menu Choices showing up..
;            DEFAULT YES
;
DISPLAY MENUCHOICES YES
;------------------------------------------------------------------------------
;
; ENTER YOUR RAW NODELIST PATH(s) BELOW (max of 5)
;------------------------------------------------------------------------------
; LISTING#   DIRECTORY       FILENAME (No Extension!)   NETWORK NAME
;---------------------------------------------------------------------------
LIST-ONE    C:\IM\NODELIST   NODELIST                  Fido Net List
; LIST-TWO    C:\IM\NODELIST   DARKNET                   Darknet Listing
; LIST-THREE  C:\IM\NODELIST   RBBSLIST                  Rbbs Network
; LIST-FOUR   C:\IM\NODELIST   ROBO-NET                  Robo/Fx Listing
; LIST-FIVE   C:\IM\NODELIST   ADULT                     Adult Net Listing
;
;------------------------------------------------------------------------------
;  LOGFILE
;
; This option allows you to specify an alternate file path and name for the
; Nodeview log file or NO log file at all.  The default will create a log file
; in the nodeview home directory.  If you don't wish to have a log file created
; then give the LOGFILE name as NONE.
;
; Default            LOGFILE NODEVIEW.LOG (defaults to Nodeview directory)
; Alternate Example  LOGFILE C:\BBS\LOGS\MYNAME.LOG
; NO Log file        LOGFILE NONE
;
LOGFILE NODEVIEW.LOG
;
;------------------------------------------------------------------------------
;  LOGDATE  (Remember to add nodeview to your maintenance batch file)
;           (Example: Nodeview /F or /H
; This option allows you to delete the logfile on a certain day of the week or
; to delete the logfile on a certain day each month.  If you specify the word
; KEEP for the logdate, then the log will not be deleted at all.
;
; To delete on a certain DATE EACH MONTH specify the date.
;
; Example: LOGDATE 1  <-- Would delete log on the first day of each month
;          LOGDATE 31 <-- Would delete log on the 31 day of each month
;
;  Deleting on a DAY OF THE WEEK is as follows:
;
;  SU for Sunday
;  MO for Monday
;  TU for Tuesday
;  WE for Wednesday
;  TH for Thursday
;  FR for Friday
;  SA for Saturday
;
;  Example: LOGDATE SU <--  Would delete log every Sunday when a user enters
;                           the door.
;
LOGDATE 1
;------------------------------------------------------------------------------
;
;  DISPLAY LONG or SHORT
;
; Two modes of display are available, long and short. The default is
; long, which displays the address, BBS name, sysop name, phone number
; city ,modem and node status. The short format is one-line without the
; city and modem information. Both display's will still be optional from
; the user menu.
;
DISPLAY LONG
;
;------------------------------------------------------------------------------
;
; REGISTRATION NUMBER
;
;  Your Registration Key Code supplied when registered.  If you have
;  already registered NODEVIEW, Simply enter your key Number here.  If not,
;  Please register NODEVIEW today..
;
REGISTRATION NUMBER 1ND10845R941E09347F
;
;------------------------------ End of File ----------------------------------

