;---- nnansi_d.asm -----------------
; Definitions for the new new ANSI driver.
; (C) 1986 Daniel Kegel
; May be distributed for educational and personal use only

; This version is for EGA/VGA only! Not for CGA or MGA or Hercules
; Modified by Tom Almy

TRUE	equ	1
FALSE	equ	0

; Define one of the following true if you have the appropriate
; display card. Otherwise leave them all FALSE.

VEGA	equ	FALSE	; Configure for Video-Seven FastWrite VGA, or
			; compatible (such as Tatung VGA (not VGA-16))
PARADISE equ    FALSE	; Paradise VGA (or EGA)
ORCHID	equ	FALSE	; Orchard Prodesigner
STBVGA  equ	FALSE	; STB VGA Extra
TVGA16	equ	FALSE	; Tatung VGA-16
EGAWIZ  equ	FALSE	; EGA Wizard Deluxe
ATT600  equ	FALSE	; AT&T VDC600 (untested)


key_redef	equ	FALSE	; keyboard redefinition allowed if true
; If you don't use this feature, set at FALSE, since some Trojan Horse 
; programs take advantage of this.
quick_char	equ	TRUE	; quick graphic characters in modes 10 and 12
; This should be "TRUE" unless you have an incompatible display card
more_sgr	equ	TRUE	; proper reverse video handling, etc
out_trans	equ	FALSE	; output translation (costs 680 bytes)
				; You probabably don't use it.
fast		equ	TRUE	; fast scrolling
	; note- you may have to clear the display (CLS command) before 
	; running some programs, or just before leaving "shell escapes" in
	; some programs.  But it's typically worth the effort.
fast29		equ	TRUE	; 15 % faster operation (overall)
				;  of int29 calls (costs 100 bytes)
takeBIOS	equ	TRUE	; take over BIOS write_tty if true
	; NOTE: if takeBIOS is true, the color rendition of text may change,
	; but performance will improve and ANSI control codes can be used.
initgc		equ	FALSE	; graphics cursor initially on if true

; Note: if neither fast nor takeBIOS specified, then there may be graphic
;       cursor problems.  But if you don't say "fast" there isn't too much
;	reason to use this package.  At any rate, if you insist on specifying
;	takeBIOS and fast as FALSE, make sure initgc is also false.

is_8088		equ	TRUE	; no fancy instructions if true
cls_homes_too	equ	TRUE	; set true for ANSI.SYS compatibility
erase_extension equ	TRUE	; allows ^[[0J and ^[[1J commands
multi_page	equ	FALSE	; if true, allows running outside page 0
				; PROBABLY DOESN'T WORK--NOT TESTED

buf_size	equ	512	; size of parameter/redef buffer 
				; (must not be smaller than about 100 bytes)

IFE	VEGA+PARADISE+STBVGA+TVGA16+EGAWIZ+ATT600+ORCHID ; default generic graphic cards.
gmode_test macro isgraphic
			; This macro is to jump if display is in an EGA/VGA
			; 16 color compatible mode. This is at minimum
			; modes 10h and 12h
	cmp	cs:video_mode, 10h	; 640x350, 16 color mode
	je	isgraphic
	cmp	cs:video_mode, 12h	; 640x480, 16 color VGA mode
	je	isgraphic
endm
gmode_code macro	; this macro is used to tell if display is in graphics
			; mode by looking at the byte 40:49H, which is in
			; register AL at the start of the macro
			; no registers may be altered.
			; *NOTE* users of Paradise and possibly other VGA
			; cards will need to modifify this routine because
			; Peradise extended character modes set this byte to
			; to the value of the mode you selected.  Nicer cards
			; (Genoa and VEGA, that I know of) leave this byte at
			; "3" and all works fine!
	mov	cs:gmode_flag,0		; assume character mode (zero flag)
	cmp	al, 4
	jb	not_graphics		; modes >4 are assumed to be graphic
	mov	cs:gmode_flag,al	; non-zero value
not_graphics:
endm
ENDIF

IF PARADISE
gmode_test macro isgraphic
	cmp	cs:video_mode, 10h	; 640x350, 16 color mode
	je	isgraphic
	cmp	cs:video_mode, 12h	; 640x480, 16 color VGA mode
	je	isgraphic
	cmp	cs:video_mode, 58h	; 800x600, 16 color
	je	isgraphic
endm
gmode_code macro
	mov	cs:gmode_flag,0		; assume character mode (zero flag)
	cmp	al, 4
	jb	not_graphics		; modes >4 are assumed to be graphic
	cmp	al, 54h			; modes 54 and 55 are text!
	je	not_graphics
	cmp	al, 55h
	je	not_graphics
	mov	cs:gmode_flag,al	; non-zero value
not_graphics:
endm
ENDIF

IF ORCHID
gmode_test macro isgraphic
	cmp	cs:video_mode, 10h	; 640x350, 16 color mode
	je	isgraphic
	cmp	cs:video_mode, 12h	; 640x480, 16 color VGA mode
	je	isgraphic
; There are more -- I just don't know them
endm
gmode_code macro
	mov	cs:gmode_flag,0		; assume character mode (zero flag)
	cmp	al, 4
	jb	not_graphics		; modes >4 are assumed to be graphic
	cmp	al, 26h			; modes 26 and 2a are text!
	je	not_graphics
	cmp	al, 2ah
	je	not_graphics
	mov	cs:gmode_flag,al	; non-zero value
not_graphics:
endm
ENDIF

IF ATT600
gmode_test macro isgraphic
	cmp	cs:video_mode, 10h	; 640x350, 16 color mode
	je	isgraphic
	cmp	cs:video_mode, 12h	; 640x480, 16 color VGA mode
	je	isgraphic
	cmp	cs:video_mode, 47h	; 800x600, 16 color
	je	isgraphic
endm
gmode_code macro
	mov	cs:gmode_flag,0		; assume character mode (zero flag)
	cmp	al, 4
	jb	not_graphics		; modes >4 are assumed to be graphic
	cmp	al, 54h			; modes 54 and 55 are text!
	je	not_graphics
	cmp	al, 55h
	je	not_graphics
	mov	cs:gmode_flag,al	; non-zero value
not_graphics:
endm
ENDIF

IF STBVGA
gmode_test macro isgraphic
	cmp	cs:video_mode, 10h	; 640x350, 16 color mode
	je	isgraphic
	cmp	cs:video_mode, 12h	; 640x480, 16 color VGA mode
	je	isgraphic
endm
gmode_code macro
	mov	cs:gmode_flag,0		; assume character mode (zero flag)
	cmp	al, 4
	jb	not_graphics		; modes >4 are assumed to be graphic
	cmp	al, 22h			; modes 22 and 23 are text!
	je	not_graphics
	cmp	al, 23h
	je	not_graphics
	mov	cs:gmode_flag,al	; non-zero value
not_graphics:
endm
ENDIF

IF TVGA16
gmode_test macro isgraphic
	cmp	cs:video_mode, 10h	; 640x350, 16 color mode
	je	isgraphic
	cmp	cs:video_mode, 12h	; 640x480, 16 color VGA mode
	je	isgraphic
endm
gmode_code macro
	mov	cs:gmode_flag,0		; assume character mode (zero flag)
	cmp	al, 4
	jb	not_graphics		; modes >4 are assumed to be graphic
	cmp	al, 56h			; modes 56 and 57 are text!
	jb	not_graphics
	cmp	al, 57h
	jb	not_graphics
	mov	cs:gmode_flag,al	; non-zero value
not_graphics:
endm
ENDIF


IF	VEGA
gmode_test macro isgraphic
	cmp	cs:video_mode, 10h	; 640x350, 16 color mode
	je	isgraphic
	cmp	cs:video_mode, 12h	; 640x480, 16 color VGA mode
	je	isgraphic
	cmp	cs:video_mode, 14h	; 752x410
	je	isgraphic
	cmp	cs:video_mode, 15h	; 720x540
	je	isgraphic
	cmp	cs:video_mode, 16h	; 800x600
	je	isgraphic
endm
gmode_code macro
	mov	cs:gmode_flag,0		; assume character mode (zero flag)
	cmp	al, 4
	jb	not_graphics		; modes >4 are assumed to be graphic
	mov	cs:gmode_flag,al	; non-zero value
not_graphics:
endm
ENDIF


IF	EGAWIZ
gmode_test macro isgraphic
	cmp	cs:video_mode, 10h	; 640x350, 16 color mode
	je	isgraphic
	cmp	cs:video_mode, 12h	; 640x480, 16 color VGA mode
	je	isgraphic
	cmp	cs:video_mode, 26h	; 640x480, 60 line
	je	isgraphic
	cmp	cs:video_mode, 70h	; 740x396
	je	isgraphic
	cmp	cs:video_mode, 71h	; 800x600
	je	isgraphic
endm
gmode_code macro
	mov	cs:gmode_flag,0		; assume character mode (zero flag)
	cmp	al, 4
	jb	not_graphics		; modes >4 are assumed to be graphic
	cmp	al, 22h			; 22-24 are nongraphic
	jb	is_graphics
	cmp	al, 24h
	jbe	not_graphics
	cmp	al, 32h			; 32-34 are nongraphic
	jb	is_graphics
	cmp	al, 34h
	jbe	not_graphics
	cmp	al, 38h			; 38 is nongraphic
	je	not_graphics
is_graphics:
	mov	cs:gmode_flag,al	; non-zero value
not_graphics:
endm
ENDIF


;Comment this out if running MASM 1.0

	if	is_8088
		.8086
	else
		.286c
	endif

;---- end of nnansi_d.asm ----

