;********************************************************************
;*    Nodelist Update Utility (NLU)  Control File                   *
;*                                                                  *
;*  Copyright 1993        Les Fenison         All rights reserved   *
;********************************************************************
;
;
; If you register, all the annoying beeps, delays, and user intervention
; will go away.   It only costs $5 to register
;
; Keywords may be in any case.
; All comments must begin with a semicolon(;)
; Keywords MUST start in column 0.  A space before a keyword will
; keep it from working.
;
; The format is a KEYWORD followed by OPTIONS
; The keyword should be followed by the option. in the following format;
; MAXDIFFS 5
; Do not include quotes such as MAXDIFFS "5".  Do not use equal signs
; such as MAXDIFFS=5.
;
; Keywords are;
;
;------------------------------------------------------------------------
; REGKEY
;      After this keyword you should enter your registration key. If you
;      are not registered then DO NOT include this keyword.  Registration
;      entitles you to free support, removes the annoying sounds and delays,
;      and removes the user intervention at the end.  It only costs $5.
;      See NLU_REG.DOC for registration information.
;
;REGKEY
;------------------------------------------------------------------------
;
; MAXDIFFS
;     Maximum number of nodediffs to keep in the download directory.  If the
;     keyword is left out nodediffs will not be purged. Same with MAXDIFFS 0
;
MAXDIFFS 5
;------------------------------------------------------------------------
;
; MAXLISTS
;     Maximum number of nodelists to keep in the download directory.  If this
;     keyword is left out nodediffs will not be purged. Same with MAXLISTS 0
;
MAXLISTS 2
;------------------------------------------------------------------------
;
; INBOUNDDIR
;     This is the path where your mailer puts the inbound files.  This
;     path is ignored unless the TOSSFILES keyword is used.
;
INBOUNDDIR E:\inbound\
;------------------------------------------------------------------------
;
; DOWNLOADDIR
;     This is the path where you keep your nodelists and nodediffs for
;     download or filerequest.
;
DOWNLOADDIR E:\FILES\NODELIST\
;------------------------------------------------------------------------
;
; NODELISTDIR
;     This is the path to your active nodelists. This is where your
;     nodelist.### files are kept and where your nodediff.### files are
;     applied to the nodelist.###.
;
NODELISTDIR E:\DB\NODELIST\
;------------------------------------------------------------------------
;
; LISTNAME
;     This keyword should be followed by the name of the nodelist file
;     with the no extension. This keyword may be used more than
;     once if you have lists for more than one net.  THIS KEYWORD MUST BE
;     USED BEFORE THE LISTDESC KEYWORD!!!!  If used more than once for more
;     than one list then the order of the lists MUST BE THE SAME AS THE
;     DESCRIPTIONS!!
;
LISTNAME NODELIST
LISTNAME FMLYLIST
LISTNAME DBNET
;------------------------------------------------------------------------
;
; DIFFNAME
;     This keyword works just like the LISTNAME keyword and follows the same
;     rules.  If specified more than once for more than one net the order
;     MUST BE THE SAME AS THE ORDER USED IN LISTNAME AND THE DESCRIPTIONS!
;
DIFFNAME NODEDIFF
DIFFNAME FMLYDIFF
DIFFNAME DBDIFF
;------------------------------------------------------------------------
;
; LISTDESC
;     Follow this keyword with the description for the NODELIST.Z##
;     in the FILES.BBS file.  This keyword is ignored unless the
;     UPDATE_FILELIST keyword is used.  If you want a day number to
;     be included in the description then replace the day number
;     with a ~D.  For example if you wanted the description to read;
;     Node list for day number 101 you would use the following;
;     LISTDESC Nodelist for day number ~D
;     If a download counter is used then it should be added here as well
;     Here is an example of a download counter;
;     LISTDESC [000] Nodelist for day number ~D
;     If you have lists for more than one network then
;     If more than one list is used for more than one net then this keyword
;     should be used enough times to cover all the lists specified in
;     LISTNAME.  The order and quantity must be exactly the same!
;
LISTDESC FidoNET nodelist for day number ~d
LISTDESC Family Net list for day number ~d
LISTDESC Dbridge net list for day number ~d
;------------------------------------------------------------------------
;
; DIFFDESC
;     This works the same as LISTDESC except it is used for the diff
;     files.
;
DIFFDESC FidoNET nodediff for day number ~d
DIFFDESC Family Net diff for day number ~d
DIFFDESC Dbridge diff for day number ~d
;------------------------------------------------------------------------
;
; LOGFILE
;     If you want a log file put the full path and file name after this
;     keyword.
;
LOGFILE E:\LOG\NLU.LOG
;------------------------------------------------------------------------
;
; LOGMODE
;            Options available for this keyword are TERSE, VERBOSE, DEBUG, and
;     NONE.
;
;LOGMODE NONE
LOGMODE TERSE
;LOGMODE VERBOSE
;LOGMODE DEBUG
;------------------------------------------------------------------------
;
; LOGSTYLE
;     Options available for this keyword are FRONTDOOR, DBRIDGE, and
;     BINK.
;
;LOGSTYLE DBRIDGE
;LOGSTYLE BINK
LOGSTYLE FRONTDOOR
;------------------------------------------------------------------------
;
; TOSSFILES
;     This keyword has no options.  If the keyword is present then files
;     will be tossed from the inbound directory specified in INBOUNDDIR to
;     the download directory specified in DOWNLOADDIR.
;
TOSSFILES
;------------------------------------------------------------------------
;
; UPDATE_FILELIST
;     This keyword has no options.  If the keyword is present then the
;     FILES.BBS files will be updated.
;
UPDATE_FILELIST
;------------------------------------------------------------------------
;
; FILELIST_ORDER
;     If the UPDATE_FILELIST keyword is not used then this keyword will be
;     completely ignored! The options for this keyword are TOP BOTTOM and SORT.
;     If TOP is used then the description will be placed on the top of the
;     FILES.BBS.  If BOTTOM is specified then the description will be placed
;     at the bottom of the FILES.BBS.  If the SORT option is specified then
;     the description will be inserted at the point where the FILE fits in
;     alphabetical order. The options TOP, BOTTOM, & SORT MUST BE IN CAPS!
;
FILELIST_ORDER SORT
;FILELIST_ORDER TOP
;FILELIST_ORDER BOTTOM
;------------------------------------------------------------------------
;
; ZIP       DOS  Command to add a file to a zip
; ZIP2      OS/2 Command to add a file to a zip
; UNZIP     DOS  Command to extract a file from a zip
; UNZIP2    OS/2 Command to extract a file from a zip
; ZIPVIEW   DOS  Command to view a zip file.
; ZIPVIEW2  OS/2 Command to view a zip file.
;
;     The above keywords are the command line syntax for ziping and
;     unzipping. DO NOT use destructive options such as -M to move
;     to a zip but rather -A to add to a zip.  Likewise for unzipping
;     don't use the command that deletes the origional .zip.  If the
;     keyword is needed and is not provided then the zipping or
;     unzipping will not take place.  More information is provided in
;     the docs.  Please read the docs!
;
;
ZIP C:\UTILITY\PKZIP -o 
ZIP2 E:\OS2UTIL\ZIP -o -j
UNZIP C:\UTILITY\PKUNZIP -o
UNZIP2 E:\OS2UTIL\UNZIP -o -j
ZIPVIEW C:\UTILITY\PKZIP -v
ZIPVIEW2 E:\OS2UTIL\UNZIP -v
;------------------------------------------------------------------------
;
; ARC       DOS Command to add a file to an arc file.
; ARC2      OS/2 Command to add a file to an arc file.
; UNARC     DOS Command extract a file from an arc file.
; UNARC2    OS/2 Command to add a file from an arc file.
; ARCVIEW   DOS Command to view the contents of an arc file.
; ARCVIEW2  OS/2 Command to view the contents of an arc file.
;
;     The above keywords are the command line syntax for arcing and
;     unarcing. DO NOT use destructive options such as -M to move
;     to a arc but rather -A to add to a arc.  Likewise for unarcing
;     don't use the command that deletes the origional .arc.  If the
;     keyword is needed and is not provided then the arcing or
;     unarcing will not take place.  More information is provided in
;     the docs.  Please read the docs!
;
;
ARC C:\UTILITY\ARC -aw
ARC2 E:\OS2UTIL\ARC2 -a
UNARC C:\UTILITY\ARC -ew
UNARC2 E:\OS2UTIL\ARC2 -eo
ARCVIEW C:\UTILITY\ARC -vw
ARCVIEW2 E:\OS2UTIL\ARC2 -v
;------------------------------------------------------------------------
;
; LZH       DOS Command to add a file to an lzh file.
; LZH2      OS/2 Command to add a file to an lzh file.
; UNLZH     DOS Command extract a file from an lzh file.
; UNLZH2    OS/2 Command to add a file from an lzh file.
; LZHVIEW   DOS Command to view the contents of an lzh file.
; LZHVIEW2  OS/2 Command to view the contents of an lzh file.
;
;     The above keywords are the command line syntax for lzhing and
;     unlzhing. DO NOT use destructive options such as -M to move
;     to a lzh but rather -A to add to a lzh.  Likewise for unlzhing
;     don't use the command that deletes the origional .lzh.  If the
;     keyword is needed and is not provided then the lzhing or
;     unlzhing will not take place.  More information is provided in
;     the docs.  Please read the docs!
;
;
LZH C:\UTILITY\lha a /xm
LZH2 E:\OS2UTIL\lh A -O
UNLZH C:\UTILITY\lha e
UNLZH2 E:\OS2UTIL\lh X -O
LZHVIEW C:\UTILITY\lha v /xm
LZHVIEW2 E:\OS2UTIL\lh V
;------------------------------------------------------------------------
;
; ARCPREF
;     Options are Z for zip, A for arc, or L for LZH.  This will specify
;     your preferance of packing methods.
;
ARCPREF Z
;ARCPREF A
;ARCPREF L
;------------------------------------------------------------------------
;
; APPLYDIFF
;     Include this keyword if you want diffs applied to lists.
;
APPLYDIFF
;------------------------------------------------------------------------
;
; APPLYCOMMAND    DOS command to apply diffs
; APPLYCOMMAND2   OS/2 command to apply diffs
;
;     After these keywords place the command to apply diffs.  If you need
;     to be in a special directory to run the command then use a batch
;     or .cmd file that does the CD for you.  It is not necessary for the
;     batch or cmd file to return you to the current directory.
;
APPLYCOMMAND E:\XLAX\DODIFF.BAT
APPLYCOMMAND2 E:\XLAX\DODIFF.CMD
;-----------------------------------------------------------------------
;
; CLEANUP
;     Cleanup has four options, LISTS, DIFFS, ALL, and NONE.  This keyword
;     has no effect if you did not include the APPLYDIFF keyword.  This
;     keyword specifies what files to cleanup after applying a nodediff.
;     With the LISTS option, the old list will be removed from the active
;     directory after applying the diff and creating the new list.  The
;     DIFFS option will cause the diff to be deleted from the active
;     directory after being applied. The ALL option cleans up both lists
;     and diffs.  The NONE option disables all cleanup the same as omitting
;     the keyword.
;
CLEANUP ALL
;CLEANUP DIFFS
;CLEANUP LISTS
;CLEANUP NONE
;-----------------------------------------------------------------------
;
; CONVERT
;     Convert has no options.  Including this keyword will cause any archived
;     files that are in a different format than the format specified in the
;     ARCPREF keyword will be converted to your prefered format.
;
CONVERT
;-----------------------------------------------------------------------
;
; SKIPTEST
;     The use of this keyword is NOT RECOMMENDED!  This keyword will disable
;     the archive confidence test that runs each time NLU is started.  The
;     confidence test tests all necessary options of the archive commands
;     to make sure they are installed properly.  In the event that you
;     install a new version of zip, arc, lha or whatever this test will insure
;     that your lists and diffs will not be trashed as a result of an
;     unexpected change.
;
;SKIPTEST
;----------------------------------------------------------------------
;
; MAGICDIR
;     Include this keyword followed by the directory where you keep your
;     nodelists and diffs for magic file request. See the docs for more
;     info.
;
;MAGICDIR E:\FILES\MAGIC
;----------------------------------------------------------------------
;
; MAGICLIST
;     Include this keyword followed by the full path and filename of your
;     magiclist if you use one.  See the docs for more info.
;
;MAGICLIST E:\DB\MAGIC.LST
;----------------------------------------------------------------------
