/*
   REXX program to extract statistics from NFTP.FLS file     Version 0.1
   Freely distributable, but copyright by Tth Ferenc <etus@alarmix.net>
   Please mail any suggestinos and/or bug report to the author.
   
   To do:
   - option to count uploads/downloads separately
   - option to sort sites according to speed or down/upload size
   - option to list only specified time interval
*/

inputfile = "nftp.fls"
outputfile = "nftp.sta"

noecho = LINEOUT(outputfile, "Date      Megabyte     Avarage speed (cps)")
noecho = LINEOUT(outputfile, "------------------------------------------")

/* Calculate the number of files and store their date/time, size etc. */
files=1
DO WHILE LINES(inputfile) > 0
  line = LINEIN(inputfile)
  month.files = SUBSTR(line, 4, 2)
  year.files = SUBSTR(line, 7, 2)
  time.files = SUBSTR(line, 10, 5)
  size.files = SUBSTR(line, 16, 9)
  if pos("(", line) = 0 then
  do
  /* old style log without speed */
    speed.files = 0
    site.files = SUBSTR(line, 27, POS(":", line, 27)-27)
  end
  else
  do
  /* new style with speed */
    speed.files = SUBSTR(line, 26, 7)
    site.files = SUBSTR(line, 40, POS(":", line, 40)-40)
  end
  files=files+1
END
files=files-1
month=month.1
year=year.1
bytes=0
time=0

/* summary */
do counter=1 to files
  if (month.counter = month) & (year.counter = year) then do
    bytes=bytes+size.counter
    if speed.counter=0 then speed.counter=1
    time=time+size.counter/speed.counter
  end
  else
  do
    if time=0 then time=1
    speed=FORMAT(bytes/time,16,0)
    if speed > 999 then speed=RIGHT(REVERSE(INSERT(",", REVERSE(STRIP(speed)), 3)),16)
    byte=FORMAT(bytes/1024/1024,8,2)
    donotecho = LINEOUT(outputfile, month"/"year||byte||speed)

    month=month.counter
    year=year.counter
    bytes=size.counter
    if speed.counter=0 then speed.counter=1
    time=size.counter/speed.counter
  end
END

if time=0 then time=1
speed=FORMAT(bytes/time,16,0)
if speed > 999 then speed=RIGHT(REVERSE(INSERT(",", REVERSE(STRIP(speed)), 3)),16)
byte=FORMAT(bytes/1024/1024,8,2)
donotecho = LINEOUT(outputfile, month"/"year||byte||speed)

noecho = LINEOUT(outputfile, "")
noecho = LINEOUT(outputfile, "Site                                      Megabyte     Avarage speed (cps)")
noecho = LINEOUT(outputfile, "--------------------------------------------------------------------------")
noecho = LINEOUT(outputfile, "")

do numsites=1 to files
  bytes=0
  time=0

  already=0
  if numsites>1 then
  do check=1 to numsites-1
    if site.numsites=site.check then already=1
  end
  if already = 0 then
  do
    do counter=1 to files
      if (site.counter = site.numsites) then
      do
        bytes=bytes+size.counter
        if speed.counter=0 then speed.counter=1
        time=time+size.counter/speed.counter
      end
    end
    speed=FORMAT(bytes/time,16,0)
    if speed > 999 then speed=RIGHT(REVERSE(INSERT(",", REVERSE(STRIP(speed)), 3)),16)
    byte=FORMAT(bytes/1024/1024,8,2)
    if speed=1 then speed=""
    donotecho = LINEOUT(outputfile, overlay(" ", site.numsites,38,0)||byte||"    "||speed)
  end
end

EXIT
