;
; Note: logical values may be specified as 0/1 or yes/no.
;
[network]
;
; your name for anonymous transfers
;
;anonymous-name=anonymous
;
; your password for anonymous logins. Insert your e-mail address here
;
;anonymous-password="your-e-mail-address"
;
; new since 0.51
;
; default ftp port. do not change unless you're know what are you doing.
; To make this feature useful create special directories for sites with
; nonstandard ports and set 'default-port' in them, not in general nftp.ini:
; nftp will look for initialization file in the current directory first,
; then in the path
;
;default-port=21
;
; new since 0.80
;
; interval (in seconds) between retries when anonymous login failed. 
; set to 0 to disable retries. default is 5 minutes
;
;login-retry=300


; new since 0.80
;
[firewalling]
;
; The firewall descriptions below are taken from WS_FTP docs.
;
; your firewall type:
; 0 - no firewalling (default)
; 1 - SITE hostname
;        Firewall host, userid and password are required.
;        User is logged on the firewall and the remote connection is
;        established using SITE remote_host.
; 2 - USER after logon
;        Firewall host, userid and password are required.
;        User is logged on the firewall and the remote connection is
;        established using USER remote_userid@remote_host
; 3 - USER with no logon
;        Firewall host required, userid and password are ignored.
;        USER remote_userid@remote_host is sent to firewall upon initial 
;        connection.
; 4 - Proxy OPEN
;        Firewall host required, userid and password are ignored.  
;        OPEN remote_host is sent to firewall upon initial connection.
;
;firewall-type=0
;
;firewall-host=
;
;firewall-login=
;
;firewall-password=
;
;firewall-port=
;
;  There is another kind of firewall, which is not specifically 
;  configured. A router-based firewall is one which allows connections 
;  to be established in one direction only.  The router itself is
;  invisible to the user.  However, the default mode within FTP is
;  that "data" connections are established by the server rather than
;  the client.  To work with a router-based firewall requires using
;  the PASV Mode of FTP.
;    This option has changed its sense in 1.02 and later. NFTP always tries
;  to work in passive mode; when server doesn't support PASV, NFTP falls 
;  back to port mode; when this option is set, NFTP gives error message
;  if server does not support passive mode. This behaviour should not
;  break existing installations
;
;use-PASV-mode=0


;-----------------------------------------------------------------------
;  Owner identification
;
[registration]
;
; Your registration name (specify exactly as typed in registration 
; form); enclose into double quotes
;name=
;
; Your registration code; enclose into double quotes. If you're
; running unregistered version, set this parameter to empty value.
;code=
;
; If you're running unregistered and hate those warnings about
; registration, set this parameter to 0 -- you'll no longer see
; warnings. Of course, files larger than 500KB will be still unreachable.
;message=1

;-----------------------------------------------------------------------

[options]
;
; dereference symlinks on server. Setting to 0 is not recommended
;
;dereference-links=1
;
; Include files starting with "." into list ?
;
;show-dotted=1
;
; Debugging. Do not set to 1 unless nftp goes crazy. Produces huge logs
;
;debug=0
;
; whether to beep at the end of transfer
;
;transfer-bell=1
;
; whether to beep when logged in
;
;login-bell=1
;
; whether to pause at transfer stats screen at the end of transfer
;
;transfer-pause=1
;
; whether to log transfers. Pretty useful option to keep history and
; statistics
;
;log-transfers=1
;
; name of transfer log. This may be global file (one for several instances
; of nftp running simultaneously).
;
;log-transfers-name=
;
; whether to ask to save current host/dir as bookmark at logoff.
; Do you remember that nCftp does this always?
;
;save-bookmark-at-logoff=0
;
; where to save bookmark information. This may be global file (one for
; several instances of nftp).
;
;bookmarks-file=
;
; external program invoked by Alt-F3. Substitute your favourite viewer/editor
;
;text-viewer="tedit.exe"
;
; whether to switch to Control Connection Window automatically when
; sending commands to server
;
;auto-switch-to-control=0
;
; next items are new since 0.5
;
; default directory sort.
; 0-unsorted, 1-by name, 2-by ext, 3-by size, 4-by time
; use negative numbers to reverse, i.e. "-3" gives small files first 
;
;default-sort=0
;
; new since 0.70
;
; if this parameter is set, nftp will change into this directory
; after start
;
;default-download-path=
;
; default view of remote directory. 1 - raw (as supplied by server),
; 2 - parsed (owner/group removed)
;
;default-dir-mode=1
;
; new since 0.80
;
; whether to set time/date of retrieved file to original values
; (as stored on server)
;
;preserve-timestamp=yes
;
; new since 0.90
;
; whether to display server info in bookmarks when description is present
;bmk-show-server-info=0
;
; default directory sort for local files
; 0-unsorted, 1-by name, 2-by ext, 3-by size, 4-by time
; use negative numbers to reverse, i.e. "-3" gives small files first 
;
;default-local-sort=0
;

; Colours are hexadecimal. First digit - foreground, second - background
; Add 80 to blink
;
; Fore             Fore                Back
; 00 black         08 darkgrey         00 black
; 01 blue          09 light blue       10 blue
; 02 green         0a light green      20 green
; 03 cyan          0b light cyan       30 cyan
; 04 red           0c light red        40 red
; 05 magenta       0d light magenta    50 magenta
; 06 brown         0e yellow           60 brown
; 07 grey          0f white            70 grey

[colours]
;
; ----- File Listing -------------------------------------------
;
; cursor pointing to marked directory (not used) (default: yellow on cyan)
;pointer-marked-dir=3e
;
; cursor pointing to marked file (default: yellow on cyan)
;pointer-marked=3e
;
; cursor pointing to directory (default: lightgreen on cyan)
;pointer-dir=3a
;
; cursor pointing to file (default: black on cyan)
;pointer=30
;
; marked directory (not used) (default: yellow on black)
;marked-dir=0e
;
; marked file (default: yellow on black)
;marked=0e
;
; directory (default: green on black)
;dir=02
;
; file (default: grey on black)
;regular-file=07
;
; ----- Dialog windows ------------------------------------------
;
; dialog window (default: grey on blue)
;dialog-box-text=17
;
; selected element in a dialog window (default: white on grey)
;dialog-box-selected=7f
;
; entry field (default: black on cyan)
;dialog-box-entryfield=30
;
; dialog window containing important information (default: grey on red)
;dialog-box-text-warn=47
;
; ----- Control Connection Window ------------------------------
;
; window header (default: grey on blue)
;controlconn-header=17
;
; server messages and responces (default: grey on black)
;controlconn-respline=07
;
; command which was sent to server (default: lightgreen on black)
;controlconn-command=0a
;
; comment (actually not a part of control connection) (default: lightred on black)
;controlconn-comment=0c
;
; ------ Bookmarks ------------------------------------------------
;
; bookmark window (default: black on grey)
;bookmark-background=70
;
; cursor (default: black on cyan)
;bookmark-pointer=30
;
; ------ Built-in File Viewer -----------------------------------
;
; file contents (default: grey on black)
;viewer-text=07
;
; status line (default: black on cyan)
;viewer-header=30
;
; string found in the text (default: bright-red on black)
;viewer-foundtext=0c
;
; -------- Miscellaneous ---------------------------------------
;
; status lines on remote directory (no. of files, no. of bytes, 
; current host/directory etc.) (default: grey on blue)
;status=17
;
; status lines on local directory (no. of files, no. of bytes, 
;  current host/directory etc.) (default: white on blue)
;status-local=1f
;
; file transfer panel (default: grey on blue)
;transfer-status=17
;
; help viewer (default: black on cyan)
;help=30
;

; Key definitions. Please note that keys should NEVER overlap, i.e. there are
; no keystrokes which act differently in different modes. You can assign
; several keystrokes to the same action; separate them by commas, e.g.:
;    enter-directory=enter,ctrl-pgdn
;
; Do not assign character keys like 'a', '4', arrow keys, Esc.
;
; Some keys (e.g., ctrl-ampersand) do not work at all; don't be surprised.
; Valid combinations are listed in the manual.
;
; Three-key combinations (like Ctrl-Shift-Left) cannot be used.
;
; Recommended assignments are alt-something, ctrl-something, f1-f12.
;
; Many default key assignments were borrowed from Norton Commander
; and File Commander/2.
;
; Default keystrokes still perform the same functions if not assigned.
; To bind a key to nothing, list it in "nothing=" line.
;
; Available key names are (they are not case-sensitive, except standalone
; character keys like 'a' and 'A'):
;
; All these parameters are of type 'string' and can take more than
; one value. Separate values by comma. Quotes aren't needed because
; key names do not contain special characters.
;
; backspace tab enter esc lrbracket([) rrbracket(]) minus plus space
; semicolon apostrophe backapostrophe backslash comma period slash
; colon doublequote lcbracket({) rcbracket(}) questionmark lessthan
; greaterthan underline equalsign lparenth"(" rparenth")" ampersand vertline(|)
; percentsign caret(^) dollar grate(#) at(@) exclamation approx(~)
; asterisk f1..f12 insert delete home end pgup pgdn numslash numasterisk
; numminus numplus numenter left right up down gold('5' on numeric keypad)
; a..z A..Z 0..9
;
; Uncomment and change value to customize

[keys]

; binds key to "no action"
;nothing=

; switches between file manager and control connection. default: space
;switch-to-cc=space
; switches between local and remote file view. default: tab
;switch-local-remote=tab
; switches to raw directory view
;directory-mode-raw=ctrl-w
; switches to parsed directory view
;directory-mode-parsed=ctrl-p

; send command to ftp server verbatim. default: alt-q
;quote=alt-q
; save current remote directory as bookmark. default: f4
;save-bookmark=f4
; exit NFTP. default: f10
;exit=f10
; log off. default: ctrl-k
;logoff=ctrl-k

; switches autoswitching to control connection on/off. default: alt-f
;autocontrol=ctrl-a
; redraws screen (do not re-reads remote directory). default: ctrl-d
;screen-redraw=ctrl-d

; log in to server from bookmark list. default: ctrl-b
;bookmarks=ctrl-b
; log in to anonymous ftp server, enter server name. default: ctrl-l
;login-anonymous=ctrl-l
; log in to private ftp server, enter server name/login/password. default: ctrl-n
;login_named=ctrl-n
; switches transfer mode between ASCII/BINARY. default: ctrl-t
;change-transfer-mode=ctrl-t
; enter remote directory name and change into it. default: alt-c
;change-directory=alt-c
; send NO OPERATION command. default: alt-n
;noop=alt-n
; switches between NLST with flags/LIST commands. default: alt-f
;useflags=alt-f

; download file(s). default: f5
;download=f5
; upload file(s). default: shift-f5
;upload=shift-f5
; download all marked files in all directories. default: alt-f5
;download-all-dirs=alt-f5
; download by name entered (useful for unreadable directories). default: alt-d
;download-byname=alt-d
; save listing of current directory. default: alt-s
;save-listing=alt-s
; how many files are marked in how many directories. default: alt-i
;information=alt-i

; view file with internal viewer. default: f3
;view-int=f3
; view file with external viewer. default: alt-f3
;view-ext=alt-f3
; delete file/directory. default: f8
;delete=f8
; create directory. default: f7
;mkdir=f7
; rename file/directory. default: f6
;rename=f6

; sort file list by name. default: ctrl-f3
;sort-name=ctrl-f3
; sort file list by extension. default: ctrl-f4
;sort-ext=ctrl-f4
; sort file list by time. default: ctrl-f5
;sort-time=ctrl-f5
; sort file list by size. default: ctrl-f6
;sort-size=ctrl-f6
; make file list to be unsorted (as supplied by server). default: ctrl-f7
;sort-unsort=ctrl-f7
; reverse sort order. default: ctrl-f8
;sort-reverse=ctrl-f8

; enter into the directory under cursor. default: enter, ctrl-pgdn
;enter-directory=enter,ctrl-pgdn
; go to the root directory. default: ctrl-backslash
;go-root=ctrl-backslash
; go to the directory one level up ("cd .."). default: ctrl-pgup
;go-up=ctrl-pgup
; re-read directory. default: ctrl-r
;reread=ctrl-r
; change local drive. default: f2
;change-local-drive=f2

; mark file for downloading/uploading/deleting. default: insert
;select=insert
; mark all files in the current directory. default: ctrl-numplus
;select-all=ctrl-numplus
; unmark all files in the current directory. default: ctrl-numminus
;deselect-all=ctrl-numminus
; mark files by user-specified filter. default: plus
;select-by-filter=plus
; unmark files by user-specified filter. default: minus
;deselect-by-filter=minus
; invert selection, default: numasterisk
;invert-selection=numasterisk
; mark all files in all visited directories. default: alt-numplus
;select-alldirs=alt-numplus
; unmark all files in all visited directories. default: alt-numminus
;deselect-alldirs=alt-numminus

; end of nftp.ini

