; File......: ISPRINT.ASM
; Author....: Ted Means
; Date......: $Date:   16 Jul 1993 00:00:18  $
; Revision..: $Revision:   1.3  $
; Log file..: $Logfile:   C:/nanfor/src/isprint.asv  $
; 
; This function is an original work by Ted Means and is placed in the
; public domain.  I got the idea from Norm Mongeau, but the code is
; all mine.
;
; Modification history:
; ---------------------
;
; $Log:   C:/nanfor/src/isprint.asv  $
;  
;     Rev 1.3   16 Jul 1993 00:00:18   GLENN
;  Modified for compatibility in protected mode under ExoSpace.  Should
;  work in real mode as well.
;  
;  
;     Rev 1.2   15 Aug 1991 23:07:56   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:38   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:26   GLENN
;  Nanforum Toolkit
;  
;


;  $DOC$
;  $FUNCNAME$
;     FT_ISPRINT()
;  $CATEGORY$
;     DOS/BIOS
;  $ONELINER$
;     Check printer status
;  $SYNTAX$
;     FT_ISPRINT( [ <cDevice> ] ) -> lResult
;  $ARGUMENTS$
;     <cDevice> is optional and is the device to test (LPT2, COM1, etc.).
;     If omitted, the function will default to the PRN device.
;  $RETURNS$
;     .T.  if device is ready for output.
;     .F.  if one of the following conditions occurs:
;          1)  The device is not ready.
;          2)  The device does not exist.
;          3)  DOS couldn't open the device for some reason
;              (such as no file handles available).
;  $DESCRIPTION$
;     The Clipper IsPrinter() function is somewhat limited because it only
;     works with LPT1.  Furthermore, it talks directly to the hardware, so
;     if you have redirected LPT1 via the DOS MODE command, the IsPrinter()
;     function will return erroneous results.
;
;     This function offers a better alternative.  Instead of talking to the
;     hardware, it issues a DOS call that checks to see if the device is
;     ready or not.  That gives DOS an opportunity to deal with any
;     redirections, and since you pass the device name as a parameter, you
;     can test any device, not just LPT1 (note that the function defaults
;     to PRN if you fail to pass a valid parameter).
;
;     The function also temporarily traps the DOS critical error handler so
;     you don't get any nasty error messages if the device isn't ready.  It
;     restores the old critical error handler before exiting.
;
;     Note that although this function is mainly designed for testing
;     printers, you can also check to see if a drive is ready.  Since DOS
;     thinks the NUL device exists on every drive, you can pass a drive
;     letter followed by NUL as a parameter.  If DOS is able to open the
;     NUL device, then the drive is ready, otherwise the door is open or
;     something else is wrong.
;
;     The source code is written to adhere to Turbo Assembler's IDEAL mode.
;     To use another assembler, you will need to rearrange the PROC and
;     SEGMENT directives, and also the ENDP and ENDS directives (a very
;     minor task).
;  $EXAMPLES$
;     IF ! FT_ISPRINT()
;        Qout( "PRN is not ready!" )
;     ENDIF
;
;     IF ! FT_ISPRINT( "COM2" )
;        Qout( "Check the device on COM2.  Something is wrong." )
;     ENDIF
;
;     IF ! FT_ISPRINT( "A:\NUL" )
;        Qout( "Oops, better check drive A!" )
;     ENDIF
;  $END$
;

         IDEAL

Public   FT_ISPRINT

Old24Vec EQU       DWord Ptr BP - 4
Old24Ofs EQU       Word Ptr BP - 4
Old24Seg EQU       Word Ptr BP - 2
Handle   EQU       Word Ptr BP - 6
OpenFlag EQU       Byte Ptr BP - 8

Extrn    __ParInfo:Far
Extrn    __ParC:Far
Extrn    __RetL:Far

Group    DGROUP    _ftData

Segment  _ftData   Word      Public    "DATA"
IsReady  DB        ?
Ends     _ftData

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor,DS:DGROUP

Proc     FT_ISPRINT          Far

         Push      BP                        ; Save BP
         Mov       BP,SP                     ; Set up stack reference
         Sub       SP,8                      ; Allocate room for locals
         Mov       [Handle],4                ; Default to PRN
         Mov       [OpenFlag],0              ; Initialize flag

         Xor       AX,AX                     ; Request param count
         Push      AX                        ; Put request on stack
         Call      __ParInfo                 ; Count params
         Or        AX,AX                     ; Zero params?
         JZ        PrtTest                   ; Yes, so use default

ParType: Mov       AX,1                      ; Specify first param
         Push      AX                        ; Put param # on stack
         Call      __ParInfo                 ; Get type
         Test      AX,1                      ; Character?
         JZ        PrtTest                   ; No, so use default

GetParam:Mov       AX,1                      ; Specify first param
         Push      AX                        ; Put param # on stack
         Call      __ParC                    ; Retrieve parameter

         Push      DS                        ; Save DS
         Mov       DS,DX                     ; Get segment of device name
         Mov       DX,AX                     ; Get offset of device name
         Mov       AX,3D01h                  ; DOS service--open file or device
         Int       21h                       ; Call DOS
         Pop       DS                        ; Restore DS
         JNC       DHandle                   ; No error, so device was opened
         Xor       AX,AX                     ; Set return value to false
         Jmp       Short RetVal              ; We're outta here

DHandle: Mov       [Handle],AX               ; Supply device's handle
         Inc       [OpenFlag]                ; Set flag so close can occur
         
PrtTest: Call      Near _FTHook24            ; Install local INT 24h handler
         Mov       [IsReady],1               ; Assume printer ready
         Mov       AX,4407h                  ; DOS service--get output status
         Mov       BX,[Handle]               ; Choose standard print device
         Int       21h                       ; Call DOS
         And       AL,[IsReady]              ; Combine error reports
         CBW                                 ; Clear high byte
         Call      Near _FTUnHook24          ; Restore old INT 24h vector

RetVal:  Push      AX                        ; Put return value on stack
         Call      __RetL                    ; Return status to Clipper app

         Cmp       [OpenFlag],1              ; Need to close device?
         JNE       Exit                      ; No, so go ahead and exit
         Mov       AH,3Eh                    ; DOS service--close handle
         Mov       BX,[Handle]               ; Supply file handle
         Int       21h                       ; Call DOS

Exit:    Mov       SP,BP                     ; Realign stack
         Pop       BP                        ; Restore BP
         Ret                                 ; Far return to Clipper app
Endp     FT_ISPRINT



Proc     _FTHook24 Near

         Push      DS                        ; Save DS

         Mov       AX,3524h                  ; DOS service--get INT 24h vector
         Int       21h                       ; Call DOS
         Mov       [Old24Ofs],BX             ; Save offset
         Mov       [Old24Seg],ES             ; Save segment value

         Push      CS
         Pop       DS                        ; Set DS to local segment
         Mov       DX,Offset _NanFor:Int_24  ; Offset of local handler
         Mov       AX,2524h                  ; DOS service--set INT 24h vector
         Int       21h                       ; Call DOS  

         Pop       DS
         Ret                                 ; Near return
Endp     _FTHook24



Proc     _FTUnHook24         Near

         Push      DS                        ; Save DS
         Push      AX                        ; Save AX
         Mov       AX,2524h                  ; DOS service--set INT 24h vector
         LDS       DX,[Old24Vec]             ; Get address of original handler
         Int       21h                       ; Call DOS
         Pop       AX
         Pop       DS
         Ret                                 ; Near return
Endp     _FTUnHook24



Proc     Int_24    Far

         Push      DS
         Mov       AX,DGROUP
         Mov       DS,AX
         Mov       [IsReady],0               ; Indicate not ready
         Pop       DS
         Xor       AX,AX                     ; Tell DOS to ignore error
         IRet
Endp     Int_24
Ends     _NanFor
End