/*
 * File......: CINT86.C
 * Author....: Ted Means
 * Date......: $Date:   15 Jul 1993 22:38:34  $
 * Revision..: $Revision:   1.0  $
 * Log file..: $Logfile:   C:/nanfor/src/exo/sav/cint86.c_v  $
 * 
 * This function is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   C:/nanfor/src/exo/sav/cint86.c_v  $
 * 
 *    Rev 1.0   15 Jul 1993 22:38:34   GLENN
 * Initial revision.
 * 
 *
 */

/* Librarian's note:
 *
 * This source code is for a special version of ft_int86(), compatible
 * with the ExoSpace (tm) DOS Extender from SofDesign, International.
 * It is ExoSpace-specific and is maintained separately from the real
 * mode version.
 *
 * The documentation can be found in the real-mode CINT86.C as
 * distributed with the regular Nanforum Toolkit.
 *
 */ 
  

#include "EXTEND.H"

typedef unsigned int UINT;
typedef unsigned char BYTE;

typedef union
{
   void far * Address;
   struct
   {
      UINT Offset;
      UINT Segment;
   } Pointer;
} FARPTR;

typedef struct
{
    UINT BX;
    UINT CX;
    UINT DX;
    UINT AX;
} WORDREGS;

typedef struct
{
    BYTE BL, BH;
    BYTE CL, CH;
    BYTE DL, DH;
    BYTE AL, AH;
} BYTEREGS;

typedef union
{
    WORDREGS w;
    BYTEREGS b;
} REGS;

typedef union
{
   UINT registers[ 10 ];
   struct
   {
      UINT DS;
      UINT ES;
      UINT DI;
      UINT SI;
      UINT BP;
      UINT SP;
      REGS regs;
   } CPURegs;
} REGISTERS;

void _bcopy( void far * pDest, void far * pSrc, UINT nBytes );

UINT ExoRMInterrupt( UINT nInt, REGISTERS far * inregs, REGISTERS far * outregs );

FARPTR _xalloclow( UINT nSize );

void _xfreelow( FARPTR * pPma );

FARPTR ExoRealPtr( FARPTR pPma );


//                      AX BX CX DX SI DI BP
static int regOff[] = {  9, 6, 8, 7, 3, 2, 4 };

CLIPPER FT_Int86( void )
{
   auto REGISTERS regs;

   auto FARPTR dsPtr;            // Pointers to incoming params
   auto FARPTR esPtr;

   auto FARPTR dsPma;            // Protected mode addresses
   auto FARPTR esPma;

   auto FARPTR dsRma;            // Real mode addresses
   auto FARPTR esRma;

   auto UINT nLenDS;
   auto UINT nLenES;
   auto UINT n;

   dsPma.Address = NULL;   dsRma.Address = NULL;
   esPma.Address = NULL;   esRma.Address = NULL;

   if ( ( PCOUNT == 2 ) && ISNUM( 1 ) && ISARRAY( 2 ) )
   {
      if ( _parinfa( 2, 8 ) & CHARACTER )
      {
         nLenDS = _parclen( 2, 8 );
         
         _storclen( NULL, nLenDS, 2, 8 ); dsPtr.Address = _parc( 2, 8 );

         dsPma = _xalloclow( nLenDS );

         _bcopy( dsPma.Address, dsPtr.Address, nLenDS );

         dsRma = ExoRealPtr( dsPma ); regs.CPURegs.DS = dsRma.Pointer.Segment;
      }
      else
         regs.CPURegs.DS = _parni( 2, 8 );

      if ( _parinfa( 2, 9 ) & CHARACTER )
      {
         nLenES = _parclen( 2, 9 );
         
         _storclen( NULL, nLenES, 2, 9 ); esPtr.Address = _parc( 2, 9 );

         esPma = _xalloclow( nLenES );

         _bcopy( esPma.Address, esPtr.Address, nLenES );

         esRma = ExoRealPtr( esPma ); regs.CPURegs.ES = esRma.Pointer.Segment;
      }
      else
         regs.CPURegs.ES = _parni( 2, 9 );

      for ( n = 1; n <= 7; n++ )
      {
         if ( _parinfa( 2, n ) & LOGICAL )
            if ( _parl( 2, n ) )
               regs.registers[ regOff[ n - 1 ] ] = dsRma.Pointer.Offset;
            else
               regs.registers[ regOff[ n - 1 ] ] = esRma.Pointer.Offset;
         else
            regs.registers[ regOff[ n - 1 ] ] = _parni( 2, n );
      }

      _storni( ExoRMInterrupt( _parni( 1 ), &regs, &regs ), 2, 10 );

      for ( n = 1; n <= 7; n++ )
         _storni( regs.registers[ regOff[ n - 1 ] ], 2, n );

      if ( dsPma.Address == NULL )
         _storni( regs.CPURegs.DS, 2, 8 );
      else
      {
         _bcopy( dsPtr.Address, dsPma.Address, nLenDS );

         _xfreelow( dsPma.Address );
      }

      if ( esPma.Address == NULL )
         _storni( regs.CPURegs.ES, 2, 9 );
      else
      {
         _bcopy( esPtr.Address, esPma.Address, nLenES );

         _xfreelow( esPma.Address );
      }

      _retl( TRUE );
   }
   else
      _retl( FALSE );

   return;
}

