//$$ newmat9.cpp         Input and output

// Copyright (C) 1991,2,3,4: R B Davies


#define WANT_STREAM

#include "include.h"

#include "newmat.h"
#include "newmatrc.h"
#include "newmatio.h"

//#define REPORT { static ExeCounter ExeCount(__LINE__,9); ++ExeCount; }

#define REPORT {}

ostream& operator<<(ostream& s, const BaseMatrix& X)
{
   GeneralMatrix* gm = ((BaseMatrix&)X).Evaluate(); operator<<(s, *gm);
   gm->tDelete(); return s;
}


ostream& operator<<(ostream& s, const GeneralMatrix& X)
{
   MatrixRow mr((GeneralMatrix*)&X, LoadOnEntry);
   int w = s.width();  int nr = X.Nrows();  long f = s.flags();
   s.setf(ios::fixed, ios::floatfield);
   for (int i=1; i<=nr; i++)
   {
      int skip = mr.skip;  int storage = mr.storage;
      Real* store = mr.store+skip;  skip *= w+1;
      while (skip--) s << " ";
      while (storage--) { s.width(w); s << *store++ << " "; }
//      while (storage--) s << setw(w) << *store++ << " ";
      mr.Next();  s << "\n";
   }
   s << flush;  s.flags(f); return s;
}

// include this stuff if you are using an old version of G++
// with an incomplete io library

/*

ostream& operator<<(ostream& os, Omanip_precision i)
   { os.precision(i.x); return os; }

Omanip_precision setprecision(int i) { return Omanip_precision(i); }

ostream& operator<<(ostream& os, Omanip_width i)
   { os.width(i.x); return os; }

Omanip_width setw(int i) { return Omanip_width(i); }

*/


