/*
 * File......: CLRRELFI.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"
#include "ftint86.ch"

#define OP_RELEASE     236      /* DON'T CHANGE THIS! */
#define OP_CLEAR       237      /* DON'T CHANGE THIS! */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_RELFILE()
 *  $CATEGORY$
 *     Synchronization
 *  $ONELINER$
 *     Release file (ASCIIZ)
 *  $SYNTAX$
 *
 *     fn_relFile( <cFile> ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <cFile> is the name of the specific file to unlock 
 *
 *  $RETURNS$
 *     
 *     <lSuccess>, .t. if you succeed, .f. if you don't.  Check
 *     FN_ERROR() for error codes.  The only valid one is 
 *
 *            255 - No files found
 *
 *   
 *  $DESCRIPTION$
 *
 *     Use fn_relFile() to unlock a specific file.
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_relfile( cFn )
  return _fnOpFile( OP_RELEASE, cFn )


/*  $DOC$
 *  $FUNCNAME$
 *     FN_RELFISE()
 *  $CATEGORY$
 *     Synchronization
 *  $ONELINER$
 *     Release file set
 *  $SYNTAX$
 *
 *     fn_relFiSe() -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     <lSuccess>, which should be meaningless because the 
 *     underlying API returns nothing.  Ignore the result
 *     code.
 *
 *  $DESCRIPTION$
 *
 *     This unlocks every file in the workstation's log table, yet
 *     leaves them in the log table.  If you happen to have left
 *     one or more files open when you "release" them, they become
 *     detached and can't be accessed until you do a LockFileSet 
 *     again.
 *
 *     If you want to clear a file from the log table, you'll 
 *     need to use fn_clrFile() or fn_clFiSet().
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *     FN_CLRFILE() FN_CLFISET()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_relFiSe()
  return _fnReq( 205, "", "" ) == ESUCCESS


/*  $DOC$
 *  $FUNCNAME$
 *     FN_CLRFILE()
 *  $CATEGORY$
 *     Synchronization 
 *  $ONELINER$
 *     Clear file (ASCIIZ)
 *  $SYNTAX$
 *   
 *     fn_clrFile( <cFn> ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *    <cFn> -  The name of the file to remove from the log table
 *
 *  $RETURNS$
 *
 *    <lSuccess>, .t. if the call succeeds, .f. if it doesn't.
 *    Check FN_ERROR() for a specific error code.  Currently the 
 *    only error code reported is code 255, "No files found."
 *
 *  $DESCRIPTION$
 *
 *    Use this call to unlock a specific file _and_ remove it from
 *    the log table.  
 *
 *    If you want to unlock all files and remove all files from 
 *    the log table, use fn_clFiSet().
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *    FN_CLFISET()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_clrFile( cFn )
  return _fnOpFile( OP_CLEAR, cFn )



/*  $DOC$
 *  $FUNCNAME$
 *     FN_CLFISET()
 *  $CATEGORY$
 *     Synchronization 
 *  $ONELINER$
 *     Clear file set
 *  $SYNTAX$
 *
 *     fn_clFiSet() -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     <lSuccess>, a value to be ignored since the underlying API
 *     returns nothing.  Pay no attention to this return value.
 *
 *  $DESCRIPTION$
 *
 *     Use this call to unlock every file in the log table, and 
 *     then wipes out the log table.  
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *      FN_CLRFILE()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_clFiSet()
  return _fnReq( 207, "", "" ) == ESUCCESS

/* ------------------------------------------------------------------ */

static function _fnOpFile( nOp, cFn )
  local aRegs[ INT86_MAX_REGS ], lRes := .f.

  if pcount() == 1 .and. valtype( cFn ) == "C" .and. !empty( cFn )

     cFn := alltrim( cFn )
     cFn := iif( len( cFn ) > 254, substr( cFn, 1, 254 ), cFn )
     cFn += chr( 0 )

     aRegs[ AX ]  := makehi( nOp )
     aRegs[ DS ]  := cFn
     aRegs[ DX ]  := REG_DS

     lRes := ft_int86( INT21, aRegs )
     if lRes 
        if UNSIGNED( LOWBYTE( aRegs[ AX ] ) ) # 0
           lRes := .f.
           _fnSetErr( UNSIGNED( LOWBYTE( aRegs[ AX ] ) ) )
        else
           _fnSetErr( ESUCCESS )
        endif
     else
        _fnSetErr( EINT86 )
     endif
  else
     _fnSetErr( EBADPARM )
  endif    

  return lRes
