/*
 * File......: SVCQJOB.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     fn_sQJobFi()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Service queue job and open file 
 *  $SYNTAX$
 *
 *     fn_sQJobFi( nQueueID, nJobType, @nHandle ) -> aJobStruct
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *     <nJobType> is the target job type this queue server will service.
 *                If you set it to -1, you'll get the first available
 *                job in the queue.
 *     <@nHandle> is a numeric, sent in by reference, and will be 
 *                replaced by the DOS file handle of the queue job file
 *                when the call returns
 *                MUST BE SENT IN BY REFERENCE!!!
 *
 *  $RETURNS$
 *         
 *      <aJobStruct>, the job entry structure for the queue.
 *      If <aJobStruct> is empty ( {} ), then there was an error
 *      that can be retrieved from FN_ERROR().
 *
 *  $DESCRIPTION$
 *
 *      Queue servers use this call to get the next job to service.
 *      Once called, the specificed queue is searched from front to 
 *      back for a job that meets the following criteria:
 *
 *            -  The Target Server ID must either be -1 or must
 *               match the ID of the server that makes the call
 *
 *            -  The target execution date must either be ctod("") 
 *               or the target execution time must be "99:99:99"
 *               or must specify a time earlier than the system 
 *               clock
 *
 *            -  The job type field must match that of the call
 *               if the call doesn't specify -1 for target job type
 *
 *            -  The job control flags "Operator Hold", "User Hold",
 *               and "Entry Open" must be .f.
 *      
 *            -  The Server ID number field must be 0, indicating
 *               that no other server is working on this job.
 *
 *     If we get a job, the job entry structure is updated to reflect
 *     your server's information (server station, server task, server
 *     ID).
 *
 *     In addition, the job file is opened and a DOS file handle is
 *     returned in <nHandle>, suitable for fwrite()ing.
 *
 *     In order to use this call, the station making the call must 
 *     have attached to the queue as a queue server first and must
 *     have the proper security (i.e., must be in the queue's 
 *     Q_SERVERS property).
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

function fn_sQJobFi( nQueueID, nJobType, nHandle )
  local cReq, cRep, aJob := {}, nJobNum

  if pcount() == 3              .and. ;
     valtype( nQueueID ) == "N" .and. ;
     valtype( nJobType ) == "N" .and. ;
     valtype( nHandle  ) == "N"

     cReq := I2BYTE( 113 ) + L2HILO( nQueueID ) + W2HILO( nJobType )   // 71h
     cRep := repl( chr(0), 54 )

     if _fnReq( 227, cReq, @cRep ) == ESUCCESS
        nJobNum := HILO2W( subs( cRep, 23, 2 ) )
        nHandle := fopen( "NETQ", 2 )                // Read-write

        /*
         *  The normal call doesn't return the entire job entry structure;
         *  it leaves out the description and the client record area.
         *  Design decision:  go ahead and call ReadQueueJobEntry to get
         *  the full data on the queue job and return it in a complete
         *  <aJobStruct>.
         */

        aJob    := fn_rdQJbEn( nQueueID, nJobNum )

     endif
  else
     _fnSetErr( EBADPARM )
  endif

  return aJob 
