/*
 * File......: RDQJENT.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     fn_rdQJbEn()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Read queue job entry
 *  $SYNTAX$
 *
 *     fn_rdQJbEn( nQueueID, nJob ) -> aJobStruct
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *     <nJob>     is the job number
 *
 *  $RETURNS$
 *         
 *      <aJobStruct>, the job entry structure for the queue.
 *      If <aJobStruct> is empty ( {} ), then there was an error
 *      that can be retrieved from FN_ERROR().
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

function fn_rdQJbEn( nQueueID, nJob ) 
  local cReq, cRep, aJob := {}

  if pcount() == 2 .and. valtype( nQueueID ) == "N" .and. valtype( nJob ) == "N"
     cReq := I2BYTE( 108 ) + L2HILO( nQueueID ) + W2HILO( nJob )
     cRep := repl( chr(0), 256 )

     if _fnReq( 227, cReq, @cRep ) == ESUCCESS
        aJob := _fnPkt2Js( cRep )
     endif
  else
     _fnSetErr( EBADPARM )
  endif

  return aJob 
