/*
 * File......: QSSTAT.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     fn_rdQSSta()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Read queue server current status
 *  $SYNTAX$
 *
 *     fn_rdQSSta( nQueueID, nServerID, nServerStation ) -> cStatus
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *
 *  $RETURNS$
 *         
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_rdQSSta( nQueueID, nServerID, nSerStat )
  local cReq, cRep, lRes := .f., cStatus := ""

  if pcount() == 3 .and. ;
     valtype( nQueueID  ) == "N" .and. ;
     valtype( nServerID ) == "N" .and. ;
     valtype( nSerStat  ) == "N"

     cReq := I2BYTE( 118  )      + ;
             L2HILO( nQueueID  ) + ;
             L2HILO( nServerID ) + ;
             I2BYTE( nSerStat  )
     cRep := repl( chr(0), 64 )
     
     if  _fnReq( 227, cReq, @cRep ) == ESUCCESS
        cStatus := padr( fn_noNull( cRep ), 64 )
     endif

  else
     _fnSetErr( EBADPARM )
  endif

  return cStatus



/*  $DOC$
 *  $FUNCNAME$
 *     fn_sQSstat()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Set queue server current status 
 *  $SYNTAX$
 *
 *    fn_sQSstat( nQueueID, cStatus ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it doesn't, check 
 *     fn_error() for one of the following error codes:
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_sQSstat( nQueueID, cStatus )
  local cReq, cRep, lRes := .f.

  if pcount() == 2 .and. valtype( nQueueID ) == "N" .and. ;
     valtype( cStatus ) == "C"

     cStatus := padr( cStatus, 64, chr(0) )

     cReq := I2BYTE( 119 ) + L2HILO( nQueueID ) + cStatus 
     cRep := ""

     lRes := ( _fnReq( 227, cReq, @cRep ) == ESUCCESS )

  else
     _fnSetErr( EBADPARM )
  endif
     
  return lRes


