/*
 * File......: CREATQ.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_CREATQ()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Create queue
 *  $SYNTAX$
 *
 *     fn_creatQ( <cName>, <nType> [,<cPath>] [,nDirHandle] ) -> nQueueID
 *
 *  $ARGUMENTS$
 *
 *     <cName> is the name of of the queue, from 1-47 characters long
 *     <nType> is the bindery object type of the queue
 *             (Defaults to OT_PRINT_QUEUE)
 *     <cPath> is optional and indicates the subdirectory associated
 *             with the queue.  It can be the full path, or an offset
 *             to the source directory handle given in <nDirHandle>.
 *             <cPath> defaults to "SYS:SYSTEM"
 *     <nDirHandle> is a directory handle, i.e., an index into the 
 *             directory handle table (see Directory services APIs).
 *             If you set this to zero (the default) you can ignore
 *             directory handles and simply use <cPath> to indicate
 *             a full path.
 *
 *  $RETURNS$
 *     <nQueueID>, the bindery object of the created queue.  If 
 *     <nQueueID> is -1, then an error occured (check FN_ERROR).
 *     Possible error returns could be:
 *
 *            { describe error returns here }
 *         
 *
 *  $DESCRIPTION$
 *
 *     Use fn_creatQ() to create a general purpose queue.  This call
 *     creates all the necessary objects and properties to
 *     store the queue in the bindery:
 *
 *         Item Q_DIRECTORY is created and contains <cPath>
 *         A subdirectory corresponding to the <nQueueID> is 
 *            created below <cPath> for queue jobs and files
 *         Properties Q_SERVERS, Q_OPERATORS, and Q_USERS are
 *            created in the bindery for this queue.  Note
 *            that these have no values (in other words, no
 *            one will be able to submit jobs or service the
 *            queues, etc until you add members to these 
 *            sets via bindery calls).
 *
 *     If this call fails, the entire transaction is backed out
 *     of the bindery.  The calling station must be SUPERVISOR
 *     equivalent.
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

function fn_creatQ( cName, nType, cPath, nDirHandle )
  local nQueueID := -1, cReq, cRep, nErr

  default nType to OT_PRINT_QUEUE, ;
          cPath to "SYS:SYSTEM",   ;
          nDirHandle to 0

  cName := upper( alltrim( cName ) )
  cName := iif( len( cName ) > 47, subs( cName, 1, 47 ), cName )
  cName += chr(0)

  if len( cName ) > 1

     cReq := I2BYTE( 100 )          + ;     // 64h
             W2HILO( nType )        + ;     // Queue type
             I2BYTE( len( cName ) ) + ;     // Queue name length
             cName                  + ;     // Queue name
             I2BYTE( nDirHandle )   + ;     // Directory Handle
             I2BYTE( len( cPath ) ) + ;     // Path name length
             cPath

     cRep := L2HILO( 0 )

     if _fnReq( 227, cReq, @cRep ) == ESUCCESS
        nQueueID := HILO2L( cRep )
     endif

  else
     _fnSetErr( EBADPARM )
  endif
     
  return nQueueID
