/*
 * File......: CFABORT.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     fn_cfabqj()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Close file and abort queue job
 *  $SYNTAX$
 *
 *     fn_cfabqj( nQueueID, nJob, nHandle ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *     <nJob>     is the job number the server wants to abort
 *     <nHandle>  is the DOS file handle returned from fn_crqjbfi()
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it doesn't, check 
 *     fn_error() for one of the following error codes:
 *
 *  $DESCRIPTION$
 *
 *     This closes a queue job file and aborts the job by
 *     removing it from the queue.  
 *
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *     fn_cqjbfi() fn_stqjob()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_cfabqj( nQueueID, nJob, nHandle )
  local cReq, cRep, lRes := .f.

  if pcount() == 3 .and. ;
     valtype( nQueueID ) == "N" .and. ;
     valtype( nJob     ) == "N" .and. ;
     valtype( nHandle  ) == "N" 

     if ( nHandle # -1 ) 
        fclose( nHandle )
     endif

     fn_remJbQ( nQueueID, nJob )

  else
     _fnSetErr( EBADPARM )
  endif

  return lRes

