/*
 * File......: GCAPSTAT.PRG
 * Author....: Christopher Shortt
 * CIS ID....: 72760,3271
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Christopher Shortt and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "ftint86.ch"
#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     fn_gLPTCap()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Gets Default LPT Capture Status
 *  $SYNTAX$
 *
 *     lLPTCapStat := fn_gLPTCap(@nServerNumber)
 *
 *  $ARGUMENTS$
 *
 *     <nServerNumber> is the Connection ID of the server queueing the job.
 *                     NOTE! THIS MUST BE PASSED BY REFERENCE
 *
 *  $RETURNS$
 *
 *    <lLPTCapStat>    is the default LPT Capture Status.
 *    <nServerNumber>  is set to the Connection ID of the server
 *                     queueing the job if the default LPT capture is on.
 *
 *  $DESCRIPTION$
 *
 *  This function returns the capture status of the default LPT. If the 
 *  default LPT is being captured the the function returns .T. and sets the
 *  nServerNumber parameter to the connection Id of the server that is
 *  queueing the LPT. When the default LPT is not being captured, the 
 *  nServerNumber parameter is set to 0.
 *
 *  The workstation maintains a Connection Id table of servers and the 
 *  nServerNumber is an index into that table.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *
 *     local   lLPTCapStat:=.F.,nServerNumber:=0
 *     lLPTCapStat := fn_gLPTCap(@nServerNumber)
 *	   QOut("Default LPT is " + IF(!lLPTCapStat,"not","") + " being captured.")
 *
 *  return NIL
 *
 *  $SEEALSO$
 *  
 *  $END$
 */


function fn_gLPTCap( nServer )
  local aRegs[INT86_MAX_REGS], lLPTCap:=.F.

	aRegs[AX]   := MakeHI(240) + 3
  _fnSetErr( iif( ft_int86( INT21, aRegs ), ESUCCESS, EINT86 ) )

  lLPTCap        := !( highbyte( aRegs[ AX ] ) == 0 )
  nServer        := iif( lLPTCap, lowbyte( aRegs[ AX ] ), 0  )

  return lLPTCap

