/*
* File......: CAPTPQUE.PRG
* Author....: Kevin Maher/Steve Tyrakowski
* CIS ID....: 73766,1224
* Date......: $Date$
* Revision..: $Revision$
* Log file..: $Logfile$
*
* This is an original work by Kevin Maher and Steve Tyrakowski
* and is placed in the public domain.
*
* Modification history:
* ---------------------
*
* $Log$
*
*/


#include "ftint86.ch"
#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     fn_sCapPQ()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Set Capture Print Queue
 *  $SYNTAX$
 *
 *     fn_sCapPQ(<nDevice>,<nPserver>,<nQueue>) -> NIL
 *
 *  $ARGUMENTS$
 *
 *     <nDevice> 1, 2, 3 for LPT1,LPT2,LPT3
 *
 *     <nPserver> the connection ID for the file server that will be
 *               handling the print request
 *
 *     <nQueue>  the Print Queue ID from the bindery
 *
 *  $RETURNS$
 *
 *     NIL
 *
 *
 *  $DESCRIPTION$
 *
 *     This function targets the next print capture to a specified
 *     print queue.
 *
 *  $EXAMPLES$
 *
 *     This function requires the follwing steps to be done in sequence.
 *     1. any current capture must be ended so that the
 *            LPTCAPTUREFLAG is set to FALSE,
 *     2. the preferred server must be set to the server that
 *            will be handling the printing
 *     3. the Queue name must be converted to a bindery ID
 *     4. call this function to set the Queue
 *     5. Start the capture
 *
 *     See the following example function:
 *
 *  LOCAL nPort := 1                             && LPT1
 *  LOCAL nServerID := FN_DefCid()               && Get server number
 *  LOCAL nQueue
 *  LOCAL cQueue := "PRINTQ_0"
 *
 *  FN_Esplptc(nPort)                            && End Lpt Capture
 *  FN_SPFCID(nServerID)                         && Set preferred server
 *  nQueue := FN_gBndOID(cQueue, OT_PRINT_QUEUE) && Get Queue ID number
 *  FN_ScapPQ( nPort, nServerID, nQueue)         && Go Set the Queue
 *  FN_sspLPTC(nPort)                                 && Start the capture
 *
 *  $SEEALSO$
 *     FN_PrintQ()
 *  $END$
 */

/*  $DOC$
 *  $FUNCNAME$
 *     fn_PrintQ()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Set Capture Print Queue
 *  $SYNTAX$
 *
 *     fn_PrintQ(<nDevice>,<cnQName>,<cPrintServer>) -> NIL
 *
 *  $ARGUMENTS$
 *
 *     <nDevice> 1, 2, 3 for LPT1,LPT2,LPT3
 *
 *     <cnQname> Print Queue Name or bindery object id of printq
 *
 *     <cPrintServer>  File Server Name to print the request (optional)
 *
 *  $RETURNS$
 *
 *     NIL
 *
 *
 *  $DESCRIPTION$
 *
 *     This function targets the next print capture to a specified
 *     print queue.  This function handles a lot of the dirty work
 *     that FN_Scappq requires to work right.  It will end the current
 *     capture, set the preferred server and translate text names
 *     into the numeric IDs needed for FN_Scappq.
 *
 *     To use it, you should just call this function, then set any
 *     capture settings, followed by starting the capture.
 *
 *  $EXAMPLES$
 *
 *     FN_PrintQ( 1, "PRINTQ_0")
 *
 *     * call FN_SdefCpf() here if desired
 *
 *     FN_sspLPTC( 1 )      &&    Start the capture
 *
 *  $SEEALSO$
 *     FN_Scappq()
 *  $END$
*/

#ifdef FT_TEST
FUNCTION Test
  LOCAL nPort := 1                               && LPT1
  LOCAL nServerID := FN_DefCid()                 && Get server number
  LOCAL nQueue
  LOCAL cQ1 := "TESTQ"                           && Use queue names thay
  LOCAL cQ2 := "PRINTQ_0"                        && exist on your server

  FN_Esplptc(nPort)                                   && End Lpt Capture

  FN_SPFCID(nServerID)                           && Set preferred server

  nQueue := FN_gBndOID( cQ1, OT_PRINT_QUEUE )  && Get Queue ID number

  FN_ScapPQ( nPort, nServerID, nQueue)         && Go Set the Queue

  FN_sspLPTC(nPort)                                 && Start the capture

  RUN CApture sh
  inkey(0)


  * This section tests the FN_PrintQ() version

  FN_PrintQ(nPort, cQ2)
  FN_sspLPTc(nPort)
  RUN CAPTURE SH

RETURN NIL
#endif

//------------------------------------------------------------

FUNCTION FN_PrintQ( nPort, cnQueue, cServer)
  LOCAL nServer := FN_DefCid()
  LOCAL nQueue, nPos
  LOCAL aSlist := FN_FSName()                    && File server name table
  IF cServer != NIL
    IF (nPos := Ascan(aSlist,Upper(cServer)) ) > 0
      nServer := nPos
    ENDIF
  ENDIF
  FN_Esplptc(nPort)                              && End Lpt Capture
  FN_SPFCID(nServer)                             && Set preferred server
  IF ValType(cnQueue) == "N"
    nQueue := cnQueue
  ELSE
    nQueue := FN_gBndOID(cnQueue, OT_PRINT_QUEUE ) && Get Queue ID number
  ENDIF

  IF FN_Error() == 0
    FN_ScapPQ( nPort, nServer, nQueue)         && Go Set the Queue
  ENDIF

RETURN NIL

//-------------------------------------------------------------

FUNCTION FN_SCapPQ( nDevice, nPServer, nQueueID )
  LOCAL aRegs[INT86_MAX_REGS]
  LOCAL cId := L2HILO(nQueueID)

  aRegs[ AX ] := makeHI(184) + 6
  // extra parens in makehi because it is preprocessed
  aRegs[ DX ] := makeHI((nDevice - 1)) + nPServer

  aRegs[ BX ] := BIN2W( Left(cID,2)  )
  aRegs[ CX ] := BIN2W( Right(cID,2) )

  IF ft_int86( INT21, aRegs )
    _fnSetErr( UNSIGNED( lowbyte( aRegs[ AX ] ) ) )
  ELSE
    _fnSetErr( EINT86 )
  ENDIF

RETURN (NIL)
