/*
 * File......: CAPFFILE.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766.1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "ftint86.ch"
#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     fn_speCapF()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Specify Capture File
 *  $SYNTAX$
 *
 *     fn_speCapF(cPath, nDriveHandle) -> lWorked
 *
 *  $ARGUMENTS$
 *
 *     <cPath> - An absolute path or a path relative to the directory
 *               handle that specifies the file to be created or used
 *               as a permanent capture file.
 *
 *     <nDriveHandle> - points to an entry in the server's directory
 *                      handle table for the calling workstation.
 *                      This is an internal table kept by Netware to
 *                      handle drive mappings.  You will need to understand
 *                      how to use some of the Directory services to use
 *                      this parameter
 *
 *                      If a 0 is passed for the nDriveHandle, then the path 
 *                      must be the full Netware Path. For example:
 *
 *                          "SYS:HOME/KEVIN/filename.ext"
 *
 *                      The user must have write access to the path.
 *
 *  $RETURNS$
 *
 *     <lWorked> - if the function call worked
 *
 *
 *  $DESCRIPTION$
 *     This function creates a disk file and directs that the next
 *     capture of print stream data go into the file.  The contents of
 *     that file are lost.  Must be used for the default print device.
 *     The file is closed when the application invokes a cancel capture,
 *     end capture or flush capture.
 *
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *  $END$
 */

#ifdef FT_TEST
    FUNCTION main()

      @ 0,0 CLEAR
      fn_elptcap()
      ? fn_speCapF("SYS:HOME/KEVIN/cf.txt", 0)
      ? fn_error()
      fn_slptcap()

      set printer to prn
      set device to print
      @ 5,5 SAY "THIS FUNCTION WORKS..."
      SET PRINTER TO
      SET DEVICE TO SCREEN

    RETURN (NIL)
#endif

FUNCTION fn_speCapF(cPath, nDriveHandle)
RETURN (_fnReq(224, I2BYTE(9) + I2BYTE(nDriveHandle) + I2BYTE(Len(cPath)) + cPath, "") == ESUCCESS)

