/*
 * File......: BANUSER.PRG
 * Author....: Christopher Shortt
 * CIS ID....: 72760,3271
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Christopher Shortt and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "ftint86.ch"
#include "netto.ch"


#define    OP_GET         8     /* Don't change! */
#define    OP_SET         9     /* Don't change! */



/*  $DOC$
 *  $FUNCNAME$
 *     fn_gBanUnm()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Returns the user name printed on banner. 
 *  $SYNTAX$
 *
 *     cRet := fn_gBanUnm()
 *
 *  $ARGUMENTS$
 *
 *     None. 
 *
 *  $RETURNS$
 *
 *     The user name printed on the banner as a character string. 
 *
 *  $DESCRIPTION$
 *
 *  This function returns the user name that is printed on the banner.
 *  If the user name has not been set with fn_sBanUnm(), the function
 *  returns the user login name.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *     return qout( "Banner User Name Is: " + fn_gBanUnm )

 *  $SEEALSO$
 *    fn_sBanUNm()
 *  $END$
 */



function fn_gBanUnm()
  return _fnban( OP_GET )



/*  $DOC$
 *  $FUNCNAME$
 *     fn_sBanUnm()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Sets the user name to be printed on the banner 
 *  $SYNTAX$
 *
 *     fn_sBanUnm( cBannerUserName ) -> nil
 *
 *  $ARGUMENTS$
 *
 *     <cBannerUserName> the name of the user that is printed on 
 *     the banner page. (Max length = 12 char)
 *
 *  $RETURNS$
 *
 *     Nil
 *
 *  $DESCRIPTION$
 *
 *  This function sets the user name to be printed on the banner. An
 *  application can only specify one banner name, and it is used for
 *  all the captured LPTs. If the user banner name is not specified,
 *  the current user's name is used.
 *
 *  $EXAMPLES$
 *
 *   function main()
 *      return fn_sBanUnm( "John Doe" )
 *
 *  $SEEALSO$
 *    fn_gBanUnm()
 *  $END$
 */



function fn_sBanUnm( cUser )
  return _fnban( OP_SET, cUser )

/* -------------------------------------------------------------------- */


static function _fnban( nOpt, cUser )
  local aRegs[ INT86_MAX_REGS ]

  cUser := iif( nOpt == OP_SET, padr( cUser, 12 ), space(12) )

	aRegs[AX] := makehi( 184 ) + nOpt
	aRegs[ES] := cUser
	aRegs[BX] := REG_ES

  _fnSetErr( iif( ft_int86( INT21, aRegs ), ESUCCESS, EINT86 ) )

  return iif( nOpt == OP_SET, nil, fn_noNull( aRegs[ ES ] ) )
     


