; File......: SWAP.ASM
; Author....: Mike Taylor, modifications by Ted Means
; CIS ID....: 73310,3013
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
; 
; This is an original work by Mike Taylor and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;  

IDEAL

Public   FT_ISwap, FT_LSwap

Extrn    __ParNI:Far
Extrn    __ParNL:Far
Extrn    __RetNI:Far
Extrn    __RetNL:Far

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

; $DOC$
; $FUNCNAME$
;    FT_ISwap()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Swap the bytes in a two byte integer
; $SYNTAX$
;
;    FT_ISWAP( <nInteger> ) -> <nRevInteger>
;
; $ARGUMENTS$
;
;    <nInteger> is the integer to be converted
;
; $RETURNS$
;
;    <nRevInteger> is <nInteger> with the bytes swapped.
;
; $DESCRIPTION$
;
;    FT_ISwap() takes the passed 2 byte integer and reverses its bytes.
;
;    For example, if you pass it an integer like x0102 it will return x0201.
;
; $EXAMPLES$
;
; $SEEALSO$
;    FT_LSwap()
; $INCLUDE$
;
; $END$
;
;

Proc     FT_ISwap  Far

         Mov       AX,1                      ; Request parameter 1
         Push      AX
         Call      __ParNI
         XChg      AH,AL
         Push      AX                        ; Return int value
         Call      __RetNI
         Add       SP,4
         Ret

Endp     FT_ISwap


; $DOC$
; $FUNCNAME$
;    FT_LSwap()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Reverse the bytes in a 4 byte long integer.
; $SYNTAX$
;
;    FT_LSWAP( <nLong> ) -> <nRevLong>
;
; $ARGUMENTS$
;
;    <nLong> is the long integer to be converted.
;
; $RETURNS$
;
;    <nRevLong> is <nLong> with the bytes reversed.
;
; $DESCRIPTION$
;
;    FT_LSwap() takes the passed 4 byte integer and reverses its bytes.
;
;    For example, if you pass it an integer like x01020304 it will
;    return x04030201.
;
; $EXAMPLES$
;
; $SEEALSO$
;    FT_ISwap()
; $INCLUDE$
;
; $END$
;
;

Proc     FT_LSwap  Far

         Mov       AX,1                      ; Request parameter 1
         Push      AX
         Call      __ParNL
         XChg      AH,AL                     ; Reverse bytes
         XChg      DH,DL
         Push      AX
         Push      DX
         Call      __RetNL
         Add       SP,6
         Ret

Endp     FT_LSwap
Ends     _NanFor
End

