; File......: FNSHL.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;

; $DOC$
; $FUNCNAME$
;    FN_SHL()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Shift the bits in an integer to the left
; $SYNTAX$
;
;    fn_shl( <nInt> | <cInt>, <nBits> ) -> nResult
;
; $ARGUMENTS$
;
;    <nInt> may either be a numeric integer, or a 16-bit character string
;    that is the binary representation of a numeric integer.
;
;    <nBits> is the number of bits to shift left and must be a numeric.
;
; $RETURNS$
;
;     <nResult>, a numeric
;
; $DESCRIPTION$
;
;      The value returned is obtained by shifting the bits in <nInt> to
;      the left.  <nBits> determines the number of bits to shift.
;      If any parameters are invalid, the function will return zero.
;
; $EXAMPLES$
;
;       ? fn_shl( 12, 2 )       // 48
;
; $SEEALSO$
; 
; $INCLUDE$
;
; $END$
;
;


IDEAL

PUBLIC   FN_SHL

EXTRN    __FNCBALL:FAR

SEGMENT  _FNNET  WORD      PUBLIC    "CODE"
         ASSUME    CS:_FNNET

PROC     FN_SHL       FAR

         MOV       AX,66D3h
         MOV       DX,0CBFAh
         JMP       __FNCBALL

ENDP     FN_SHL
ENDS     _FNNET
END

