; File......: FNROL.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;

; $DOC$
; $FUNCNAME$
;    FN_ROL()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Rotate bits in an integer to the left
; $SYNTAX$
;    
;    fn_rol( <nInt1> | <cInt1>, <nBits> ) -> nResult
;
; $ARGUMENTS$
;  
;   <nInt1> may either be a numeric integer, or a 16-bit character string
;   that is the binary representation of a numeric integer.  
;
;   <nBits> is the number of bits to rotate and must be a numeric.
;
; $RETURNS$
;
;   <nResult>, a numeric
;
; $DESCRIPTION$
;
;   The value returned is obtained by rotating the bits in <nInt1>
;   to the left.  <nBits> determines the number of bits to rotate.
;   If any parameters are invalid, the function will return zero.
;
; $EXAMPLES$
;
;   nX := -32768
;   nNum := fn_rol( nX, 2 )
;   ? nNum      // 2
;
; $SEEALSO$
;
; $INCLUDE$
;
; $END$
;
;

IDEAL

PUBLIC   FN_ROL

EXTRN    __FNCBALL:FAR

SEGMENT  _FNNET  WORD      PUBLIC    "CODE"
         ASSUME    CS:_FNNET

PROC     FN_ROL       FAR

         MOV       AX,46D3h
         MOV       DX,0CBFAh
         JMP       __FNCBALL

ENDP     FN_ROL
ENDS     _FNNET
END

