; File......: FNNOT.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;

; $DOC$
; $FUNCNAME$
;    FN_NOT()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Perform a bitwise NOT on an integer
; $SYNTAX$
;
;    fn_not( <nInt> | <cInt> ) -> nResult
;
; $ARGUMENTS$
;
;   <nInt> may either be a numeric integer, or a 16-bit character string
;   that is the binary representation of a numeric integer.
;
; $RETURNS$
;
;   <nResult>, a numeric
;
; $DESCRIPTION$
;
;   The value returned is obtained by performing a bitwise NOT with
;   <nInt> as the operand. If any parameters are invalid, the function
;   will return zero.
;
; $EXAMPLES$
;
;   nX := 0
;   nNum := fn_not( nX )
;   ? nNum      // -32768
;
; $SEEALSO$
;
; $INCLUDE$
;
; $END$
;
;


IDEAL

PUBLIC   FN_NOT

EXTRN    __FNCBALL:FAR

SEGMENT  _FNNET  WORD      PUBLIC    "CODE"
         ASSUME    CS:_FNNET

PROC     FN_NOT       FAR

         MOV       AX,56F7h
         MOV       DX,0CBFAh
         JMP       __FNCBALL

ENDP     FN_NOT
ENDS     _FNNET
END
