/*
 * File......: XDIRECT.PRG
 * Author....: Gregory Anthony
 * CIS ID....: 70045,1160
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Gregory Anthony and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     Overview
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     File System Services Overview
 *  $DESCRIPTION$
 *     
 *  The File System Services APIs allow an application to retrieve directory
 *  and volume information.  With these APIs the programmer can create, rename,
 *  and delete directories, modify a directory's maximum rights mask, add and
 *  delete trustees, allocate and deallocate directory handles, etc.
 *
 *  $TABLES ACCESSED BY FSS$
 *
 *  The workstation shell and file server maintain tables used by the FS.
 *
 *  A Directory Table holds information about a file servers directories
 *  and directory structure and is maintained by the file server.  To do this
 *  the table hold three different node entries.  They are directory, file
 *  and trustee nodes.  The directory node holds the directory name, attribute
 *  byte, maximum rights mask, creation date, creator object ID, parent
 *  directory link, and trustee node link, if any.  The file node holds the
 *  filename, attribute byte, extended attribute byte, filesize, date created,
 *  date last accessed, date last updated, last archive date, owner object ID,
 *  and link to parent directory node.  The trustee node holds the object IDs
 *  of up to five trustees, corresponding rights masks, link to parent
 *  directory node, and a link to the next trustee node, if there are more
 *  than five trustees.
 *
 *  A file server maintains a Directory Handle Table (DHT) for each workstation
 *  logged.  Any of the 255 entries (1-255) can be set to point to a volume or
 *  path.  Workstations have three corresponding tables that relate to the DHT.
 *  Each table holds 32 records, corresponding to the permanent (A-Z) and
 *  temporary ([,\,],^,_,') drive letters.  The Drive Handle Table holds a
 *  directory handle index into the file servers DHT.  A Drive Flag Table holds
 *  info indicating if the drive is allocated, permanent or temporary, local or
 *  networked.  The file server to which a drive is mapped is maintain in the
 *  Drive Connection ID Table index into Server Name Table and Connection
 *  Information Table.
 *
 *  Drive numbers of each search drive mapped is maintained in the Search
 *  Drive Vector.
 *
 *  A Volume Table is maintained on the file server which tracks volumes
 *  mounted, along with each volumes information; volume name, total blocks,
 *  sectors/block, available blocks, total directory slots, available
 *  directory slots, and whether volume is removable.  The volume table has
 *  a maximum of 32 entries (0-31) under NetWare 286.  NetWare 386 increases
 *  this maximum.
 *
 *  There are 5 calls in the FS API that are supported by functions in the
 *  NETTO library for volumes.  Get Volume Name - FN_VOLNAME(), Get Volume
 *  Number - FN_VOLNUM(), Get Volume Info With Handle - FN_VOLINFH(), Get
 *  Volume Info With Number - FN_VOLINFN(), and Get Volume Information -
 *  FN_VOLINF().
 *
 *  $DIRECTORY HANDLES$
 *
 *  The only directory handles available to a program are those associated
 *  with drives or search drives in the Drive Handle Table and Search Drive
 *  Vector and also any handles the program may allocate relative to the
 *  existing handles.  A directory handle provides an index into the Directory
 *  Handle Table, which points to the Directory Table and the Volume Table.
 *  The directory handle describes a volume and directory.  A developer can
 *  use directory handle calls to find handles given to drive numbers, set
 *  handles to other directories and to save or restore handles.
 *
 *  The call Get Directory Handle - FN_GETDH() is used to find the directory
 *  to which a drive is mapped.  Set Directory Handle - FN_SETDH() allows
 *  changing the path a handle points to by giving another handle or path.
 *  Save Directory Handle - FN_SAVDH() and Restore Directory Handle -
 *  FN_RESDH() allows an application to save and restore its operating
 *  enviroment for batch jobs, printing or remote job handling.  Restore
 *  Directory Handle also returns the effective rights mask for the directory.
 *
 *  File System Services API provides functions that a program can use to
 *  allocate its own directory handles.  These functions can be used to map
 *  drives.  Most users are familiar with NetWares MAP command.  With
 *  Allocate Permanent Directory Handle - FN_ALPERDH(), a programmer can map
 *  a drive that will last past the termination of the program that created
 *  it.  Allocate Temporary Directory Handle - FN_ALTEMDH(), allows mapping
 *  a drive for the duration of the session that created it or until the
 *  program that allocated it call the End Of Job function.  If a temporary
 *  directory name is the same for a permanent handle that already exists, the
 *  permanent handle will be lost.  Also temporary handles differ from
 *  permanent handles in that several temporary directory handles can be
 *  assigned the same drive letter but still be separately mapped to different
 *  directories.  Deallocate Directory Handle - FN_DEALDH() is used to remove
 *  a permanent or temporary directory handle and its associated drive
 *  mapping.
 *  Currently unsupported by the NETTO library are the Map Drive,
 *  Set Drive Path, Allocate Special Directory Handle, Is Search Drive, Get
 *  Search Drive Vector and Set Search Drive Vector calls.  Map Drive allows
 *  mapping of network drive letters to directories and can also be used to
 *  map and unmap search drives.  Set Drive Path allows a program to change
 *  the directory to which a drive is mapped or create a new drive mapping.
 *  The search drive vector is like DOS's PATH and consists of an array of
 *  15 directory handles corresponding to each of the shell's search drives.
 *  The Is Search Drive call can be used to determine if a drive letter is
 *  mapped as a search drive.  The Get Search Drive Vector call returns the
 *  search drive vector and Set Search Drive Vector allows setting the search
 *  drive vector to a array of directory handles.  Novell encourages developers
 *  to use Map Drive rather than Set Search Drive Vector for changing search
 *  Drive mappings.  Allocate Special Directory Handle is basically like
 *  the MAP ROOT command in NetWare.  The mapped directory cannot be changed.
 *  This call may not be supported in the future.
 *
 *  $DIRECTORY OPERATIONS$
 *
 *  Just like under DOS the File System Services provide calls in NetWare for
 *  performing fundamental directory operations.  The developer can create,
 *  delete, rename, and change directories.  There are also calls to get and
 *  set directory information like owner and security.  One thing to remember
 *  is that before making one of these calls is to ensure that the file
 *  server that you want to perform the action on is the current file server.
 *  You can set the Shell to the preferred connection by calling Set Preferred
 *  Connection ID - FN_SPFCID() (Connection/Workstation APIs).
 *
 *  Create Directory - FN_MKDIR() creates a directory on the file server.
 *  Delete Directory - FN_RMDIR() deletes a directory on the file server.
 *  Get Current Directory - FN_GETCD() Gets current directory of a drive.
 *  Get Directory Path - FN_GETPATH() returns a directory path given a
 *  directory handle.  Rename Directory - FN_RENDIR() allows renaming a
 *  directory on the file server.  Scan Directory Information and Set
 *  Directory Information (eg, date of creation, owner, maximum rights mask)
 *  are not currently supported by the NETTO library.
 *
 *  $TRUSTEES AND RIGHTS$
 *
 *  Trustees and rights information and management functions are currently
 *  unsupported by the NETTO library.
 *     
 *  $END$
 */

static function X_Direct()
  return nil
