/*
 * File......: SHOWDOT.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"
#include "ftint86.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     fn_showDot()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Set "SHOW DOT" parameter
 *  $SYNTAX$
 *
 *     fn_showDot( <lShowDot> ) -> lOldDot
 *
 *  $ARGUMENTS$
 *
 *     <lShowDot> is a logical, .t. if you want to set 
 *     SHOW DOTS on, .f. if you want to turn it off.
 *
 *  $RETURNS$
 *
 *     The old value of the SHOW DOT setting, as a logical (.t. if
 *     SHOW DOTS=ON, .f. if it was OFF.)
 *
 *  $DESCRIPTION$
 *
 *     If SHOW DOTS is turned on, the "." and ".."  directory entries
 *     will show up in directory listings.  If it's off, they won't.
 *     Windows 3.x requires the SHOW DOTS parameter set on.
 *
 *  $EXAMPLES$
 *
 *     fn_showdot( .t. )     // turn SHOW DOTS on
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_showDot( lDot )
  local aRegs[ INT86_MAX_REGS ], lRes

  if pcount() == 1 .and. valtype( lDot ) == "L"
     aRegs[ AX ] := makehi( 233 ) + 8    // E9 08
     aRegs[ BX ] := iif( lDot, 1, 0 )
     _fnseterr( iif( ft_int86( INT21, aRegs ), ESUCCESS, EINT86 ) )
     lRes := !(lowbyte( aRegs[ BX ] )  == 0 )
  else
     _fnseterr( EBADPARM )
  endif

  return lRes
