/*
 * File......: GETRIGHT.PRG
 * Author....: Michael A. Cohen
 * CIS ID....: 72007,276
 * Date......: $Date: 28 May 1993 02:35:00$
 * Revision..: $Revision: 1.0$
 * Log file..: $Logfile$
 *
 * This is an original work by Michael Cohen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     FN_GetRights()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get effective rights to a Netware directory
 *  $SYNTAX$
 *
 *     fn_GetRights( <cDirectory> ) -> <cRights>
 *
 *  $ARGUMENTS$
 *
 *     <cDirectory> corresponds to a directory path, including drive letter
 *
 *  $RETURNS$
 *
 *     <cRights> returns a string of rights (RWOCDPSM).
 *
 *  $DESCRIPTION$
 *
 *     This call returns the current rights for a directory.
 *     R - Read
 *     W - Write
 *     O - Open
 *     C - Create
 *     D - Delete
 *     P - Parental
 *     S - Scan
 *     M - Modify
 *
 *  $EXAMPLES$
 *       function main( cDirectory )
 *
 *          local cRights
 *
 *          cRights := fn_GetRights( cDirectory )
 *
 *       return(NIL)
 *
 *  $SEEALSO$
 *    FN_Rights()
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#ifdef FT_TEST
   function main( cDirectory )
       ?  fn_getrights( cDirectory )
   return NIL
#endif


function fn_getrights( cDirectory )
// Get the drive letter from the directory. (first two characters)
local cRequest
local cReply := chr(0) ,nReply
local cRights,nRights
local cDrive,nDrive,nHandle,cPath,cRoot
cDirectory := iif(empty(cDirectory),ft_default()+":"+curdir(),cDirectory)
nDrive  := Drivenum(cDirectory)
nHandle := fn_getdh(nDrive)
if nHandle > 0
   cRoot := fn_getroot(nHandle,substr(cDirectory,1,2))   // Needed for map root drives
   cPath := iif(empty(cRoot),"","\"+cRoot)+substr(cDirectory , 3)
   cRequest := chr(3) + chr(nHandle) + chr(len(cPath)) + cPath

   _fnReq( 226, cRequest, @cReply )

   nReply := iif(fn_Error() == 0, asc(cReply),0)
   cRights:=""

   cRights+=iif(fn_isbit(nReply,0),"R","")
   cRights+=iif(fn_isbit(nReply,1),"W","")
   cRights+=iif(fn_isbit(nReply,2),"O","")
   cRights+=iif(fn_isbit(nReply,3),"C","")
   cRights+=iif(fn_isbit(nReply,4),"D","")
   cRights+=iif(fn_isbit(nReply,5),"P","")
   cRights+=iif(fn_isbit(nReply,6),"S","")
   cRights+=iif(fn_isbit(nReply,7),"M","")
else
   cRights:="RWOCDPSM"  // Assume it is a local drive, or Non-Novell drive
endif

return cRights

Function fn_getroot(nHandle,cDrive)
// Get the fake root directory
LOCAL cCurpath,cRootpath,cCurdir
cCurdir := fn_getcd(drivenum(cDrive)+1)
ft_chdir(cDrive+"\")             // Switch to root to get the root stuff
cRootpath := fn_getpath(nHandle)
cRootpath := substr(cRootpath,at(":",cRootpath)+1)
ft_chdir(cDrive+cCurdir)         // Switch back to the original directory
Return cRootpath

STATIC Function drivenum(cDirectory)
// Return the drive number (A = 0, B = 1) for a directory (Novell style)
LOCAL nDrive,cDrive
cDrive := substr(cDirectory,1,1)
nDrive := asc(upper(cDrive))-asc("A")
Return nDrive
