/*
 * File......: GETDIRHA.PRG
 * Author....: David A. Minter
 * CIS ID....: 76247,3475
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by David Minter and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "ftint86.ch"
#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     FN_GETDH()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get a directory handle from a drive number
 *  $SYNTAX$
 *
 *		 fn_GetDH( <nDriveNumber> ) -> <nDirectoryHandle>
 *
 *  $ARGUMENTS$
 *
 *		 <nDriveNumber> corresponds to an index into the Drive Handle Table
 *		 (0 to 31) for permanent drives (A..Z) (0..25) and temporary drives
 *		 ([,\,],^,_,') (26..31).  Drive A is 0, drive F is 5, etc.
 *
 *  $RETURNS$
 *
 *		 <nDirectoryHandle> is the index into the Directory Handle Table.
 *
 *  $DESCRIPTION$
 *
 *		 This call returns the current directory handle for a drive.
 *
 *  $EXAMPLES$
 *			function main( cDrive )
 *			
 *				local nDirHandle
 *			
 *				nDirHandle := fn_GetDirHan( asc( upper( cDrive ) ) - 65 )
 *			
 *				? fn_DelMap( nDirHandle )
 *			
 *			return(NIL)
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#ifdef FT_TEST

  function main( cDrive )
     return qout( fn_getDH( val( cDrive ) )

#endif


function fn_getDH( nDrive )
  local aRegs[ INT86_MAX_REGS ]

	aRegs[ AX ] := MAKEHI( 233 )
	aRegs[ DX ] := nDrive
	
  if !ft_int86( INT21, aRegs )
     _fnSetErr( EINT86 )
  endif

  return UNSIGNED( LOWBYTE( aRegs[ AX ] ) )
