/*
 * File......: FISVCPY.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_FSCPY()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     File server file copy
 *  $SYNTAX$
 *
 *     fn_fscpy( hSrc, hDest, [nSrcOff], [nDestOff], [nBytes] ) -> nWritten
 *
 *  $ARGUMENTS$
 *
 *     <hSrc>     is a DOS file handle (returned via fopen() or 
 *                fcreate() ) for the source file
 *
 *     <hDest>    is a DOS file handle (returned via fopen() or 
 *                fcreate() ) for the destination file
 *
 *     <nSrcOff>  is the offset (in bytes) from the beginning of
 *                the source file where copying should begin
 *                Defaults to 0.
 *
 *     <nDestOff> is the offset (in bytes) from the beginning of
 *                the destination file where copying should begin
 *                Defaults to 0.
 *
 *     <nBytes>   is the number of bytes from the source file that
 *                should be copied.
 *                Defaults to the length of the source file.
 *
 *  $RETURNS$
 *
 *     <nWritten>, the number of bytes actually copied.
 *     There are no specific error codes available for this API.
 *
 *     You can check fn_error() for EINT86 (ft_int86 error) or
 *     EBADPARM (you didn't send in enough parameters).
 *
 *  $DESCRIPTION$
 *
 *     The "File Server FIle Copy" API allows you to copy parts
 *     of a file to another file at the file server level -- 
 *     in other words, the server does all the work and your workstation
 *     is not involved.  
 *
 *     The source file and destination file must reside on the same
 *     server (no local drives or different servers).  The handles
 *     are returned from low level file i/o calls like Clipper's 
 *     fopen() or fcreate().
 *
 *     This API is interesting because you can copy bytes right into
 *     the middle of a file, etc.
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"
#include "ftint86.ch"

#ifdef FT_TEST
   function ncopy( cSrc, cDest )
      local hSrc, hDest

      if ( hSrc := fopen( cSrc ) ) > 0
         if ( hDest := fcreate( cDest ) ) > 0
            qout( "Num bytes written:", fn_fscpy( hSrc, hDest ) )
            qout( "fn_error()", fn_error() )
         else
            qout( "Can't create dest file", ferror() )
         endif
      else
         qout( "Can't open src file", ferror() )
      endif

      return nil
#endif

function fn_fscpy( hSrc, hDest, nSrcOff, nDestOff, nBytes )
   local aRegs[ INT86_MAX_REGS ], cReq, nRet := 0

   if pcount() >= 2
      default nSrcOff  to 0, ;
              nDestOff to 0, ;
              nBytes   to _fnlen( hSrc )

      cReq := i2bin( hSrc     ) + ;
            i2bin( hDest    ) + ;
            l2bin( nSrcOff  ) + ;
            l2bin( nDestOff ) + ;
            l2bin( nBytes   )

      aRegs[ AX ] := makehi( 243 )    // F3h
      aRegs[ ES ] := cReq
      aRegs[ DI ] := REG_ES

      if ft_int86( 33, aRegs )
         nRet := bin2l( i2bin( aRegs[ CX ] ) + i2bin( aRegs[ DX ] ) )
      else
         _fnSetErr( EINT86 )
      endif
   else
      _fnSetErr( EBADPARM )
   endif

   return nRet
      
/* ---------------------------------------------------------------- */

static function _fnLen( h )
   local nOld, nLen

   nOld := fseek( h, 0, 1 )
   nLen := fseek( h, 0, 2 )
   fseek( h, nOld )

   return nLen

