/*
 * File......: EXTATTR.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"
#include "ftint86.ch"

#define OP_GET           0   /* Don't change these defines! */
#define OP_SET           1

// Attr array is
//   5 = Transactional
//   6 = Index
//   7 = Read Audit
//   8 = Write Audit
//
// Since 6,7,8 are either unused or not valid in some versions of 
// NetWare, I've decided not to document these calls for now.
// Instead, I have fn_isTrans() and fn_setTran() as wrappers so
// that the transactional bit can be set/cleared.
// -- Glenn Scott (3/93)

// Get Extended File Attributes

function fn_gExtFA( cFile )
   return _fnextfa( OP_GET, cFile )

// Set Extended File Attributes

function fn_sExtFA( cFile, aBits )
   return _fnextfa( OP_GET, cFile, aBits )

/* ----------------------------------------------------------------------- */

static function _fnextfa( xOp, cFile, aBits )
   local aRegs[ INT86_MAX_REGS ], xRet

   aRegs[ AX ] := makehi( 182 ) + xOp     // B6h
   aRegs[ DS ] := cFile + chr(0)
   aRegs[ DX ] := REG_DS
   aRegs[ CX ] := iif( xOp == OP_SET, _fnba2num( aBits ), 0 )

   if !ft_int86( INT21, aRegs )
      _fnSetErr( EINT86 )
   else
      _fnSetErr( lowbyte( aRegs[ AX ] ) )
   endif

   if xOp == OP_GET
      xRet := _fnnum2ba( lowbyte( aRegs[ CX ] ) )
   else
      xRet := ( lowbyte( aRegs[ AX ] ) == 0 )
   endif

   return xRet

/* ----------------------------------------------------------------------- */

static function _fnba2num( a )
   local n := 0, x 

   for x := 1 to len( a )
      if a[x]
         n := fn_setbit( n, x - 1 )
      endif
   next

   return n

/* ----------------------------------------------------------------------- */

static function _fnnum2ba( n )
   local a := array( 16 ), x

   for x := 0 to 15
      a[ x + 1 ] := fn_isbit( n, x )
   next

   return a

/* ----------------------------------------------------------------------- */



      






