/*
 * File......: FSLOGIN.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_GFSLOGS()
 *  $CATEGORY$
 *     File Server
 *  $ONELINER$
 *     Get File Server Login Status
 *  $SYNTAX$
 *
 *     fn_gFSLogS() -> lEnabled
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     <lEnabled>, logical TRUE (.t.) if logins are enabled;
 *     FALSE (.f.) if they aren't.
 *
 *  $DESCRIPTION$
 *
 *      This call returns the login status of the current server.
 *
 *  $EXAMPLES$
 *
 *      qout( "Logins are" + iif( fn_gFSLogS(), "", " not " ) + " enabled." )
 *
 *  $SEEALSO$
 *      fn_disLog() fn_enaLog() 
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_gFSLogS()
  local cRep  := I2BYTE( 0 )
  return iif(  _fnReq( 227, I2BYTE( 205 ), @cRep ) == 0, !( BYTE2I(cRep) == 0 ), .t. )


/*  $DOC$
 *  $FUNCNAME$
 *     FN_DISLOG()
 *  $CATEGORY$
 *     File Server
 *  $ONELINER$
 *     Disable file server login
 *  $SYNTAX$
 *
 *     fn_disLog() -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     <lSuccess>, logical TRUE (.t.) if the call succeeds;
 *     FALSE (.f.) if the user doesn't have console operator 
 *     privleges.
 *
 *  $DESCRIPTION$
 *
 *     This call disables file server logins.  Once issued, 
 *     no one can log in, not even the supervisor.  One must
 *     either re-enable them with fn_enaLog() or via the console
 *     command ENABLE LOGIN.
 *
 *  $EXAMPLES$
 *
 *     qout( "Disabling logins" )
 *     if fn_gFSLogS()
 *        fn_disLog()
 *     endif
 *
 *  $SEEALSO$
 *     fn_enaLog() fn_gsFSLogS() 
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_disLog()
  return _fnReq( 227, I2BYTE( 203 ), W2HILO( 0 ) ) == 0



/*  $DOC$
 *  $FUNCNAME$
 *     FN_ENALOG()
 *  $CATEGORY$
 *     File Server
 *  $ONELINER$
 *     Enable file server login
 *  $SYNTAX$
 *
 *     fn_enaLog() -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     <lSuccess>, logical TRUE (.t.) if the call succeeds;
 *     FALSE (.f.) if the user doesn't have console operator 
 *     privleges.
 *
 *  $DESCRIPTION$
 *
 *     This call enables file server logins previously 
 *     disabled via fn_disLog() or the console command 
 *     DISABLE LOGIN.
 *
 *  $EXAMPLES$
 *
 *     qout( "Enabling logins" )
 *     if !fn_gFSLogS()
 *        fn_enaLog()
 *     endif
 *
 *  $SEEALSO$
 *     fn_disLog() fn_gsFSLogS() 
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_enaLog()
  return _fnReq( 227, I2BYTE( 204 ), W2HILO( 0 ) ) == 0


