/*
 * File......: WHOAMI.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      FN_WHOAMI()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      Return a user name
 *  $SYNTAX$
 *
 *      fn_whoami( [<nConnection>] ) -> cUserName
 *
 *  $ARGUMENTS$
 *
 *      <nConnection>.  Optional, defaults to current connection
 *      number.  If supplied, fn_whoami() will return the user
 *      logged in at logical connection number <nConnection>.
 *      <nConnection> is numeric and can be anything from 1 to 
 *      250.
 *
 *  $RETURNS$
 *
 *      The name of the user, as a character string.  It will be
 *      all uppercase and will be no longer than 48 characters.
 *
 *  $DESCRIPTION$
 *
 *      This is a high-level wrapper around fn_conninf() that just
 *      returns the username -- for people who don't want to go 
 *      through the trouble of learning the oh-so-complicated 
 *      fn_conninf() syntax...
 *     
 *  $EXAMPLES$
 *
 *      qout( "Current user is: " + fn_whoami() )
 *
 *  $SEEALSO$
 *     fn_conninf()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_whoami( nConn )
  default nConn to fn_connNum()
  return fn_conninf( nConn )[3]

