/*
 *   File......: GetSN.Prg
 *   Author....: Sheldon Easterbrook
 *   CIS ID....: 71421,254
 *   Date......: $Date$
 *   Revision..: $Revision$
 *   Log File..: $LogFile$
 *
 *   This is an original work by Sheldon Easterbrook and is placed in the
 *   Public Domain
 *
 *   Modification History:
 *   ---------------------
 *
 *   $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     Fn_GetSN()
 *  $CATEGORY$
 *     Connection/Workstation
 *  $ONELINER$
 *     Get file server name
 *  $SYNTAX$
 *
 *      Fn_GetSN( <nConnId> ) -> <cServerName>
 *
 *  $ARGUMENTS$
 *
 *      <nConnId> - Is the connection id of the server.
 *      Defaults to the value of fn_defCID() (default connection ID)
 *
 *  $RETURNS$
 *
 *     <cServerName> - Is the name of the server associated with
 *                     <nConnId>.
 *
 *  $DESCRIPTION$
 *
 *      This function returns the server name of the specified connection
 *      ID.
 *
 *  $EXAMPLES$
 *
 *      ? Fn_GetSN( Fn_DefCId())
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#Include "netto.Ch"

function Fn_GetSN( nConnId )
   default nConnID to fn_defcid()
   return Fn_FSName()[ nConnId ]
