/*
 * File......: EMODE.PRG
 * Author....: Steve Larsen
 * CIS ID....: 76370,1532
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Steve Larsen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "ftint86.ch"
#include "netto.ch"

#define E3h	227


/*  $DOC$
 *  $FUNCNAME$
 *      fn_setEMod()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      SetNetwareErrorMode
 *  $SYNTAX$
 *
 *      fn_setEMod( [ <nErrorMode> ] -> nPreviousErrorMode
 *
 *  $ARGUMENTS$
 *
 *      <nErrorMode> is the mode to set (0 - 2).  If omitted it
 *      defaults to 0.
 *
 *  $RETURNS$
 *
 *      The error mode setting prior to making this function call.
 *
 *  $DESCRIPTION$
 *
 *      This function call sets a mode that determines how the shell responds
 *      to DOS emulation call errors.  It has no effect on Netware specific
 *      calls.  DOS differentiates between normal errors and critical errors.
 *      Normal errors are listed in the DOS Technical Reference manual.
 *      Critical errors are typically nonrecoverable errors detected by DOS
 *      which then invoke the INT 24h Critical Error Handler.  Whether an
 *      error code or INT 24h in invoked is determined by the specific error.
 *
 *      The shell has three error modes: 0, 1, and 2.
 *
 *      Mode 0 is the default mode and follows the common response format
 *      used by DOS (i.e., "Abort, Retry, Fail?").
 *
 *      Mode 1 causes the shell to not invoke the INT 24h handler, instead
 *      returning the NetWare error code for all file I/O in register AL.
 *
 *      Mode 2 causes the shell to attempts to map the NetWare error code to
 *      a DOS errorcode and return that instead.
 *
 *      Both error modes 1 and 2 will cause the shell to return error codes
 *      instead of invoking INT 24h on some, but not all, network errors.
 *
 *      For an application that uses the DOS function calls (v3.0 and
 *      greater), the shell returns the standard DOS extended error codes.
 *      An application is free to install its own INT 24h Critical Error
 *      Handler.
 *
 *      NOTE:  If an application running DOS 3.1 or greater users network-
 *      aware calls (extended open, etc.) it does not matter what the
 *      Netware Error Mode is set to.  The shell returns the same errors
 *      that DOS would in the same situation.  For example, if an
 *      application attempts to open a locked file, the shell will return
 *      a DOS Error 5, "Access Denied".
 *
 *      It is also important to note that all Netware errors that go to
 *      the user screen go through INT 24h and, therefore, can be trapped
 *      and acted upon under program control using a critical error handler.
 *
 *      The error mode is automatically reset to mode 0 whenever an End Of
 *      Job occurs.  A child process inherits the error mode set by its
 *      parent.  However, if a child process set the error mode, the error
 *      mode is not inherited by the parent.  When control returns from the
 *      parent to DOS, the error mode is reset to the default mode of 0.
 *
 *  $EXAMPLES$
 *
 *      The following are two examples of how modes 0, 1, and 2 handle errors:
 *
 *      Example 1:   Noncritical file I/O: Application attempts to open
 *                   a file without having open privileges.
 *
 *      Mode 0:  No error message.  Returns a DOS error 2 in AL.
 *      Mode 1:  Returns an extended error 130 in AL.
 *      Mode 2:  Returns a DOS error 2 in AL (because file I/O was
 *               noncritical).
 *
 *      Example 2:  Netware critical file I/O:  Application attempts to
 *                  open (file handle) a file that is already open.
 *						  (If the open attempt uses extended modes, Netware
 *						  returns in DOS Error 5, "Access Denied".)
 *
 *      Mode 0:  Network error:file in use during OPEN.  The shell
 *               invokes INT 24h and the following message appears on the
 *					  screen:
 *
 *			             File=<filename> ... Abort, Retry, Ignore?
 *
 *      Mode 1:  Returns an extended error 128 in AL.
 *      Mode 2:  Returns an extended error 128 in AL.
 *
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_setEMod( nErrMode )
	LOCAL aRegs[ INT86_MAX_REGS ]
	DEFAULT nErrMode TO 0

	aRegs[ AX ] := ft_Hex2Dec( "DD00" )           // Netware Service DDh
	aRegs[ DX ] := nErrMode

	IF !ft_int86( INT21, aRegs )                  // Call Netware
		_fnSetErr( EINT86 )
  	ENDIF

RETURN ( UNSIGNED( LowByte( aRegs[ AX ] ) ) )
