/*
 * File......: DRVINFO.PRG
 * Author....: Steve Larsen
 * CIS ID....: 76370,1532
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Steve Larsen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "ftint86.ch"
#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      fn_numLDrv()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetNumberOfLocalDrives
 *  $SYNTAX$
 *
 *      fn_numLDrv() -> nDrives
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      The number of local drives on the current workstation.
 *
 *  $DESCRIPTION$
 *
 *      This function determines the number of local drives on the current
 *      workstation, which is used by the shell to determine at which letter
 *      to begin mapping network drives.
 *
 *      Unless LASTDRIVE was used in the station's CONFIG.SYS, or the station
 *      has additional hard or RAM drives, the default for this function is
 *      generally 5, which is the number of logical drives set aside by DOS.
 *
 *  $EXAMPLES$
 *
 *      ? fn_numLDrv()                           // 5
 *
 *  $SEEALSO$
 *      fn_gDrvFT()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_numLDrv()
	LOCAL aRegs[ INT86_MAX_REGS ], nRetVal

	aRegs[ AX ] := ft_Hex2Dec( "DB00" )           // Netware Service DBh

	IF !ft_int86( INT21, aRegs )                  // Call Netware
		_fnSetErr( EINT86 )
  	ENDIF

RETURN ( UNSIGNED( LowByte( aRegs[ AX ] ) ) )  // nDrives is in AL


/*  $DOC$
 *  $FUNCNAME$
 *      fn_gDrvFT()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetDriveFlagTable
 *  $SYNTAX$
 *
 *      fn_gDrvFT() -> aDriveFlags
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      A 32 element array containing a flag indicating each drive's status.
 *
 *  $DESCRIPTION$
 *
 *      The Drive Flag Table contains 32 entries, one for each logical drive.
 *      Each flag indicates a drive's status, as follows:
 *
 *           0    =   drive isn't mapped
 *           1    =   permanent network drive
 *           2    =   temporary network drive
 *         128    =   local drive
 *         129    =   local drive allocated as permanent network drive
 *         130    =   local drive allocated as temporary network drive
 *
 *  $EXAMPLES$
 *
 *      /* Determine if current drive is local */
 *
 *      IF ( fn_gDrvFT()[ 66 - ft_Default() ] ) == 127
 *         < ... drive is local... >
 *      ENDIF
 *
 *  $SEEALSO$
 *      fn_numLDrv() fn_gDrvCID()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_gDrvFT()
	LOCAL aRegs[ INT86_MAX_REGS ], aReply[ 32 ], cTemp, i

	aRegs[ AX ] := ft_Hex2Dec( "EF01" )           // Netware Service EFh, Function 1h

	IF !ft_int86( INT21, aRegs )                  // Call Netware
		_fnSetErr( EINT86 )
  	ENDIF

	FOR i := 1 TO 32
		aReply[ i ] := ft_Peek( aRegs[ ES ], aRegs[ SI ]++ )
	NEXT

RETURN ( aReply )


/*  $DOC$
 *  $FUNCNAME$
 *      fn_gDrvCID()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetDriveConnectionIDTable
 *  $SYNTAX$
 *
 *      fn_gDrvCID() -> aConnectionID
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      A 32 element array containing the file server Connection ID
 *      associated with that drive.  A value of 0 indicates that the drive
 *      is not mapped to a file server (local drive or drive not used).
 *
 *  $DESCRIPTION$
 *
 *      This function indicates which servers are mapped to by each of the
 *      32 possible logical drives.
 *
 *  $EXAMPLES$
 *
 *			/* make the server currently mapped to drive H: the preferred 
 *          server */
 *       
 *       nDrvID := fn_gDrvCID()[ 8 ]
 *       
 *       fn_sPfCID( nDrvID )
 *
 *  $SEEALSO$
 *       fn_gDrvFT()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_gDrvCID()
	LOCAL aRegs[ INT86_MAX_REGS ], aReply[ 32 ], i

	aRegs[ AX ] := ft_Hex2Dec( "EF02" )           // Netware Service EFh, Function 1h

	IF !ft_int86( INT21, aRegs )                  // Call Netware
		_fnSetErr( EINT86 )
  	ENDIF

	FOR i := 1 TO 32
		aReply[ i ] := ft_Peek( aRegs[ ES ], aRegs[ SI ]++ )
	NEXT

RETURN ( aReply )
