/*
 * File......: XBIND.TXT
 * Author....: Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Steve Tyrakowski and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     OVERVIEW
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     
 *  $SYNTAX$
 *
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *
 *  $DESCRIPTION$
 *
 *   The functions that access the bindery are very powerful tools
 *   for the Clipper programmer.  As Peter Parker has learned
 *   after being bitten by a radioactive spider, "With great
 *   power comes great responsibility."
 *
 *   A couple years back, when a 3rd party network library suggested
 *   that they were going to add bindery update functions to their
 *   product, I remember reading several messages on CompuServe
 *   from people who said that such a product would not be allowed
 *   in their shops because of the death  and destruction it could
 *   cause.  Well this approach is utter nonsense, because Novell
 *   publishes the API to access the bindery, and anyone with the API
 *   could write the code to do it -- having a library function just
 *   makes it easier.
 *
 *   Their fear is not unfounded though.
 *
 *   YOU CAN REALLY REALLY MESS THINGS UP BAD on your server
 *   if you don't know what you are doing!!
 *
 *   Danger Will Robinson, Danger!!
 *
 *   Well then, why on earth do we want to give easy access to the
 *   Netware bindery to any Clipperhead with a modem?  Because the
 *   bindery is Netware's own database, and a neat example of client
 *   server in action.  The bindery also has great information for
 *   security for your apps.  You can base security on the GROUPS
 *   in Netware, or you can make up your own property for application
 *   security.
 *
 *   Access to the bindery is protected by Netware's own security.
 *   This means that if SYSCON does not give you access to something,
 *   using the NETTO API for the bindery access will not magically
 *   give you access rights.  This is your first defense
 *   against accidentally messing up the bindery, if the network
 *   administrator hasn't given you access, you still can't change it.
 *
 *   But what if you are the network administrator?  Aren't you
 *   walking around with a loaded pistol?  Yep pardner you sure are.
 *
 *   Is there any way that I can play safely with this stuff while I'm
 *   learning what the bindery is all about?  Yes!  Limit your playing to
 *   those functions that only READ the bindery info, not update it.
 *   Actually, this is all you need to do to use the Novell groups as
 *   a basis for your application security.
 *
 *   When you do get brave enough to try updating the bindery, you
 *   should be aware of a few things:
 *
 *           * the bindery is a very dumb database.  You can easily
 *             mess it up.  Consider testing your stuff on a test
 *             file server, not a production file server.
 *
 *           * The bindery is a very dumb database, so SYSCON
 *             does a lot of work. The SYSCON utility that
 *             accesses the standard bindery properties
 *             such as GROUPS_I'M_IN, and GROUP MEMBERS has to
 *             keep all those things in sync.  When you add a
 *             new user, it makes several updates to the bindery.
 *             It creates a new object (the user itself), then it
 *             adds the user to the GROUP_MEMBERS property
 *             of the EVERYONE group, and it also adds the
 *             EVERYONE group to the user's GROUPS_I'M_IN property.
 *             That's right, just to do that it made three seperate
 *             bindery update calls, and there were probably
 *             more done behind the scenes.  If you plan to update
 *             any of the standard properties, you need to know
 *             what SYSCON expects.  Unfortunately, I've not
 *             found any good documentation for this, so tread
 *             with caution.
 *
 *  Effect of NetWare 4.0 on the Bindery
 *  ------------------------------------
 *
 *  Although Novell will be removing the bindery in NetWare 4.0, they
 *  will not be removing the API.  Novell is moving to a new, 
 *  distributed system database called "Directory Services."  This 
 *  will have its own API.  Novell 4.0 servers can do something called
 *  "bindery emulation" where the existing bindery API functions will
 *  work.  You won't be able to access the more powerful directory 
 *  services stuff but your APIs should work correctly.
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

static function xbind()
        return nil
