/*
 * File......: SCANOBJ.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_scaBndO()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Scan Bindery Object
 *  $SYNTAX$
 *
 *     FN_scaBndO(cObjectName, nObjectType) => aObjectInfo
 *
 *  $ARGUMENTS$
 *
 *     <cObjectName> is the name of the Object that you are trying
 *	   to find.  Wild Cards are allowed. Max Length = 47
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *	   describing the defined types are included in the NETTO.CH
 *	   header file.  Wild Card value OT_WILD is allowed.
 *
 *  $RETURNS$
 *
 *     <aObjectInfo>
 *
 *     Is an array which contains one or more elements, depending
 *     if wild cards are used, which have seven values each.
 *
 *
 *	 aObjectInfo[x,1] is the Object Name from the Bindery that
 *			  corresponds to the ObjectId (i.e. the return
 *			  value from the GetBinderyObjectName call)
 *
 *	 aObjectInfo[x,2] is the ObjectId which is used as a parameter
 *			  for other Bindery Functions
 *
 *	 aObjectInfo[x,3] is the Object Type for this element in the SET.
 *			  see the OT_????? definitions in the NFNET.CH
 *			  for more info about what types have been defined.
 *
 *	 aObjectInfo[x,4] is true if the property is dynamic and false
 *			  if property is static.
 *
 *	 aObjectInfo[x,5] is the object write security as an integer.
 *                        The integer indicates who can change the object
 *                        and add properties to the bindery object.
 *
 *	 aObjectInfo[x,6] is the object read security as an integer.
 *			  The integer indicates who can scan for
 *			  and find the object.
 *
 *          Ŀ
 *           Read and Write Security Levels  
 *          Ĵ
 *           0 Anyone                       
 *          Ĵ
 *           1 Logged                       
 *          Ĵ
 *           2 Object                       
 *          Ĵ
 *           3 Supervisor                   
 *          Ĵ
 *           4 Netware Operating System     
 *          
 *
 *	 aObjectInfo[x,7] is true if Object has properties to scan.
 *
 *  $DESCRIPTION$
 *
 *     This function lets you scan for bindery objects by name and type.
 *     Wild card can be used for both name and type.  The Objects get
 *     returned as an array in which each element cooresponds to a
 *     different object. If an error occurs or no objects were found
 *     matching search string, nil is returned
 *
 *  $EXAMPLES$
 *
 *     // this will return an array with info to all users of a network
 *     aObjects := FN_scaBndO("*", OT_USER)
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG     227

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType)
  LOCAL aObjects
    DEFAULT cObject TO "*"
    DEFAULT nType   TO "1"  // OT_USER
    aObjects := FN_scaBndO(cObject, Val(nType))
    Qout("Object                   ID           TYPE ISDYNAMIC    WRITE    READ IFVALUE")
    Aeval(aObjects, {|aObj| Qout(PAD(aObj[1],20),aObj[2],aObj[3],aObj[4],aObj[5],aObj[6],aObj[7])})
    Qout(fn_error())

  RETURN ( nil )

#endif

FUNCTION FN_scaBndO(cObject, nType)
  LOCAL cReceive := Space(57)
  LOCAL aObjects := {}
  LOCAL nError
  LOCAL cSend := I2BYTE(55);   //37h
		+L2HILO(-1);
		+W2HILO(nType);
		+FN_NAMEL(cObject,48)

  DO WHILE (nError := _fnReq(NW_LOG, cSend, @cReceive)) == ESUCCESS

    Aadd(aObjects, { ;
    FN_NoNull(Substr(cReceive,7,48));               // object name
        , HILO2L(Left(cReceive,4));                 // object id
        , HILO2W(Substr(cReceive,5,2));             // object type
        , Substr(cReceive,55,1) == Chr(1);          // static/dynamic flag
        , Int(BYTE2I(Substr(cReceive,56,1))/16);    // property_write_security
        , Int(BYTE2I(Substr(cReceive,56,1)) % 16) ; // property_read_security
        , Substr(cReceive,57,1) == Chr(255) })      // object_has_value

    // call again with this object id, so that it will
    // find the NEXT one after it.
    cSend := Stuff(cSend, 2, 4, Left(cReceive, 4))

  ENDDO

  IF nError == NO_SUCH_OBJECT .AND. !Empty(aObjects)
    // error is 252 when there are no more Objects to search
    _fnSetErr(ESUCCESS)
  ELSE
    // if no Objects were found or an error occured, return nil
    aObjects := nil
  ENDIF

RETURN aObjects
