/*
 * File......: OBJLISTS.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_FSLIST()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Get a sorted list of file server names
 *  $SYNTAX$
 *
 *     fn_fslist() -> aList
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     A sorted array of character strings corresponding to the
 *     names of all known file servers found in the current 
 *     file server's bindery.
 *
 *
 *  $DESCRIPTION$
 *
 *     This call provides a simple way to pop up a list of file
 *     server names.  Once the user selects one, you might need
 *     the bindery object ID (which you can retrieve with the 
 *     fn_gbndoid() call).
 *
 *  $EXAMPLES$
 *
 *     achoice( fn_fslist() )
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_fslist()
   return _fnNamList( OT_FILE_SERVER )

/*  $DOC$
 *  $FUNCNAME$
 *     FN_ULIST()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Get a sorted list of user names
 *  $SYNTAX$
 *
 *     fn_ulist() -> aList
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     A sorted array of character strings corresponding to the
 *     names of all known users found in the current  file server's
 *     bindery.
 *
 *
 *  $DESCRIPTION$
 *
 *     This call provides a simple way to pop up a list of user
 *     names.  Once the user selects one, you might need
 *     the bindery object ID (which you can retrieve with the 
 *     fn_gbndoid() call).
 *
 *  $EXAMPLES$
 *
 *     achoice( fn_ulist() )
 *
 *  $SEEALSO$
 *    FN_FSLIST() FN_GRPLIST() FN_PRQLIST()
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_ulist()
   return _fnNamList( OT_USER )

/*  $DOC$
 *  $FUNCNAME$
 *     FN_GRPLIST()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Get a sorted list of user groups
 *  $SYNTAX$
 *
 *     fn_grplist() -> aList
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     A sorted array of character strings corresponding to the
 *     names of all known user groups found in the current file server's
 *     bindery.
 *
 *
 *  $DESCRIPTION$
 *
 *     This call provides a simple way to pop up a list of user
 *     groups.  Once the user selects one, you might need
 *     the bindery object ID (which you can retrieve with the 
 *     fn_gbndoid() call).
 *
 *  $EXAMPLES$
 *
 *     achoice( fn_grplist() )
 *
 *  $SEEALSO$
 *    FN_FSLIST() FN_ULIST() FN_PRQLIST()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_grplist()
   return _fnNamList( OT_USER_GROUP )

/*  $DOC$
 *  $FUNCNAME$
 *     FN_PRQLIST()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Get a sorted list of print queue names
 *  $SYNTAX$
 *
 *     fn_prqlist() -> aList
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     A sorted array of character strings corresponding to the
 *     names of all known print queues found in the current
 *     file server's bindery.
 *
 *
 *  $DESCRIPTION$
 *
 *     This call provides a simple way to pop up a list of print
 *     queue names.  Once the user selects one, you might need
 *     the bindery object ID (which you can retrieve with the 
 *     fn_gbndoid() call).
 *
 *  $EXAMPLES$
 *
 *     achoice( fn_prqlist() )
 *
 *  $SEEALSO$
 *    FN_FSLIST() FN_GRPLIST() FN_ULIST()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_prqlist()
   return _fnNamList( OT_PRINT_QUEUE )

/* ------------------------------------------------------------------ */

function _fnNamList( xType )
   local aArr
   local aRes := {}

   aArr := fn_scabndo( "*", xType )
   if !empty( aArr )
      aeval( aArr, { |x| aadd( ARes, x[1] ) } )
      asort( aRes )
   endif

   return aRes




