/*
 * File......: NWRDPROP.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_rdProVa()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Read property value
 *  $SYNTAX$
 *
 *     FN_rdProVal(cObjectName, nObjectType, cPropertyName, lKeepNulls) =>
 *	   aSetInformation | cPropertyValue
 *
 *  $ARGUMENTS$
 *
 *     <cObjectName> is the name of the Object that you are trying
 *		     to read the property info for. Max Length = 47
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *		     describing the defined types are included in the
 *		     NETTO.CH header file.
 *
 *     <cPropertyName> is the name of the Property that you are looking up.
 *		       Max Length = 15
 *
 *     <lKeepNulls> is an optional parameter that allows you to receive
 *		    the entire 128 byte field returned for an ITEM property.  By
 *		    default, the string returned for an ITEM property is
 *		    truncated at the first NULL character to simplify use.
 *
 *		    Note that up to 255 segments of 128 bytes may be used to
 *		    store the value, so the return string could be as long
 *		    as 32,640 bytes.  The practical Max length s/b 128.
 *
 *  $RETURNS$
 *
 *     <aSetInformation>
 *
 *     If the Property being read is a SET property (i.e. a list of multiple
 *     entries), then the return value is a multidimensional array containing
 *     three values for each item in the SET.
 *
 *	  aReturn[x,1] is the ObjectId which is used as a parameter
 *		       for other Bindery Functions
 *
 *	  aReturn[x,2] is the Object Name from the Bindery that corresponds
 *		       to the ObjectId (i.e. the return value from the
 *		       GetBinderyObjectName call)
 *
 *	  aReturn[x,3] is the Object Type for this element in the SET.
 *		       see the OT_????? definitions in the NFNET.CH
 *		       for more info about what types have been defined.
 *
 *     <cPropertyValue>
 *
 *     IF the property being read is not a SET property, then the return
 *     value is a character string that contains the info supplied by the
 *     bindery.  Only info up to, but not including the first null found
 *     is returned. i.e. the string is "cleaned up" before the function
 *     sends it to you.  The lKeepNulls optional parameter allows you
 *     to override the null-stripping and receive the full 128 byte value.
 *
 *     An Item property can have a value of any data type.  It is defined
 *     by the application using the bindery, not in the bindery itself.  
 *     As such, an Item property can only be returned as a character string,
 *     this function cannot assume any data type so the value in the bindery
 *     is returned without modicication.  It is up to the programmer to know
 *     the format of the data that they are trying to inspect.
 *
 *     Completion status is set internally and may be inspected by the
 *     FN_Error() function.  A status code of 0 signifies Success.
 *
 *     If an error occured the function will return a nil.
 *
 *  $DESCRIPTION$
 *
 *     This function allows you to find the property value for an object
 *     that is contained in the Bindery.  A set Property is returned as
 *     an array to simplify using it in your code.
 *
 *  $SEEALSO$
 *     fn_wrProVal() fn_adBndO() fn_dBndOSe()
 *
 *  $EXAMPLES$
 *
 *     #include netto.ch
 *
 *     // this will return the value of a item property
 *     cPropertyValue :=  FN_rdProVal("GUEST",OT_USER,"IDENTIFICATION")
 *
 *     // this will return the values of a set property as an array
 *     aSetInfo := FN_rdProVal("EVERYONE",OT_USER_GROUP,"GROUP_MEMBERS")
 *
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#define NW_LOG     227

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType, cProp)

    LOCAL nError   := nil
    LOCAL xReturn

    DEFAULT cObject  TO "EVERYONE"
    DEFAULT cProp    TO "GROUP_MEMBERS"
    DEFAULT nType    TO OT_USER_GROUP

    IF ValType(nType) == "C"  ;  nType := Val(nType)   ; ENDIF

    Qout(Replicate("",80))
    Qout("Testing:",cObject,nType,cProp)
    Qout()

    xReturn := FN_rdprova(cObject, nType, cProp)
    IF Valtype(xReturn) == "A"
      QOut(" Type    Name                  nId")
      Aeval(xReturn,{|aArray|Qout(aArray[3],"    ",aArray[2],"   ",aArray[1])})
    ELSE
      QOut(xreturn)
    ENDIF
    QOut("Nanfor Return Code:")
    QQOut(fn_Error())
    QOut(Replicate("",80))


  RETURN ( nil )

#endif

FUNCTION FN_rdProVa(cObject, nType, cProperty, lKeepNulls)
  LOCAL cSend
  LOCAL cReceive
  LOCAL acReturn
  LOCAL nSegment := 1
  LOCAL nPos
  LOCAL cName,nObjType
  LOCAL cID

  DEFAULT lKeepNulls TO .F.

  ///////////////// Set up request packet  /////////////////////////////////

    cSend := I2BYTE(61);		// 3Dh	API Function Request Code
	   + W2HILO(nType);		// Object Type as NW int
	   + FN_NameL(cObject,48);	// Length encoded Object Name String
	   + I2BYTE(nSegment);		// Segment number
	   + FN_NameL(Upper(cProperty),16)     // Length encoded PropertyName String

	// See	crtprop.prg for Upper(cProperty) discussion


  ///////////////// Set up reply packet    /////////////////////////////////

    cReceive := Space(130)


  DO WHILE _fnReq(NW_LOG, cSend, @cReceive) == ESUCCESS

       /////////////////// SET Properties ///////////////////

    IF FT_ISBIT(Substr(cReceive,130,1), 1) // Check the SET indicator
      IF nSegment == 1 ; acReturn := {} ; ENDIF
      nPos := 1

      DO WHILE nPos < 128
        cId := Substr(cReceive, nPos, 4)  // Read bindery ID
        IF HILO2L(cId) == 0         // Check for end of segment
          EXIT
        ENDIF
        cName := FN_BndOName(cId, @nObjType)    // Lookup Name & Type
        Aadd(acReturn, {HILO2L(cId), cName, nObjType }) // and put in Return Array
        nPos += 4           // then point to next ID
      ENDDO

       ////////////////// ITEM Properties ///////////////////
    ELSE
      IF nSegment == 1 ; acReturn := "" ; ENDIF
      acReturn += Left(cReceive, 128)

    ENDIF

    cSend := Stuff(cSend,53,1,I2BYTE(++nSegment))  // point to next segment

  ENDDO

  IF FN_Error() == NO_SUCH_SEGMENT .AND. !Empty(acReturn)  // 236
    _fnSetErr(ESUCCESS)
  ELSE
    acReturn := nil
  ENDIF

  IF !lKeepNulls .AND. ValType(acReturn) == "C"
    acReturn := fn_noNull(acReturn)
  ENDIF

RETURN (acReturn)
