/*
 * File......: MAILDIR.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_MAILDIR()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Return the user's directory in SYS:MAIL
 *  $SYNTAX$
 *     
 *     fn_mailDir( [<cUser>] ) -> cMailDir
 *
 *  $ARGUMENTS$
 *
 *    <cUser> is the user for which you want to find the mail directory.
 *    Defaults to the current user.
 *
 *  $RETURNS$
 *
 *    <cMailDir>, a string containing the mail directory path, without
 *    a trailing backslash ("\").
 *
 *  $DESCRIPTION$
 *
 *    When a user is created via SYSCON, SYSCON automatically creates
 *    a directory for that user in SYS:MAIL\xxx, where "xxx" is a 
 *    hexidecimal number representing that user's bindery object ID.
 *    This call allows you a quick way to access that directory by
 *    doing the bindery object ID lookup for you, as well as the 
 *    hex conversion.
 *
 *    The user's personal login script (if she has one), is kept in 
 *    this directory.
 *    
 *  $EXAMPLES$
 *
 *    The following is a complete login script editor.
 *    
 *        #include "netto.ch"
 *        function scriptEd( cUser )
 *           local cFile
 *           default cUser to fn_whoami()
 *           cFile := fn_maildir( cUser ) + "\login"
 *           return memowrit(  cFile, memoedit( memoread( cFile ) ) )
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

function fn_mailDir( cUser )
   local nObjID
   default cUser to fn_whoami()

   nObjID := fn_gbndoid( cUser, OT_USER ) // Get object ID for user

   return "sys:mail\" + fn_bin2hex( l2bin( ft_lswap( nObjID ) ) ) 

