/*
 * File......: LOGCTL.TXT
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_LOGCTL()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Return a user's LOGIN_CONTROL property
 *  $SYNTAX$
 *
 *     fn_logctl( [<cUser>] ) -> aCtlStruct
 *
 *  $ARGUMENTS$
 *
 *    <cUser>, the name of the user for which you want to retrieve
 *    the LOGIN_CONTROL property value out of the bindery.  
 *    Defaults to current user.
 *
 *  $RETURNS$
 *
 *    If the call is successful, an array is returned with the
 *    following structure:
 *
 *             Index                      Contents
 *             ------         -----------------------------------
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


#include "netto.ch"

#ifdef FT_TEST
   function main( cUser )
      default cUser to fn_whoami()

      cls
      aeval( fn_logctl( cUser ), { |x| qout( x ) } )
      return nil
#endif


function fn_logctl( cUser ) 
   local cProp, aRes := {}

   default cUser to fn_whoami()

   cProp := fn_rdprova( cUser, OT_USER, "LOGIN_CONTROL" )
   if fn_error() == 0
      aRes :=  { ;
         subs( cProp, 1, 3 ),           ; // Accounting expiration date
         BYTE2I( subs( cProp, 4, 1 ) ) == -1 , ; // Account disabled flag
         subs( cProp, 5, 3 ),           ; // Password expiration date
         BYTE2I( subs( cProp, 8, 1 ) ), ; // Grace logins remaining
         HILO2W( subs( cProp, 9, 2 ) ), ; // Password expiration interval
         BYTE2I( subs( cProp, 11, 1 ) ),; // Grace login reset value
         BYTE2I( subs( cProp, 12, 1 ) ),; // Minimum password length
         HILO2W( subs( cProp, 13, 2 ) ),; // Maximum concurrent connections
         subs( cProp, 15, 42 ),         ; // Allowed login time bitmap
         subs( cProp, 57, 6 ),          ; // Last login date & time
         BYTE2I( subs( cProp, 63, 1 ) ),; // Restriction flags
         BYTE2I( subs( cProp, 64, 1 ) ),; // Unused
         HILO2L( subs( cProp, 65, 4 ) ),; // Max disk usage in blocks
         HILO2W( subs( cProp, 69, 2 ) ),; // Bad login count
         HILO2L( subs( cProp, 71, 4 ) ),; // Next reset time
         subs( cProp, 75 )              ; // Bad login address
      }
   endif

   return aRes

      

   

