/*
 * File......: INGROUP.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_INGROUP()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Determine if user is in a user group
 *  $SYNTAX$
 *     
 *     fn_inGroup( <cGroup> [,<cUser> | <nConn> ] ) -> lInGroup
 *
 *  $ARGUMENTS$
 *     
 *    <cGroup> is the name of the user group that you will test for
 *    the user's membership status.
 *
 *    The second parameter can be either a character or a numeric, 
 *    and is optional.  You can place one of two values in the second
 *    parameter:
 *
 *       <cUser> is the user name to test
 *       <nConn> is the logical connection number to test
 *
 *    If the second parameter is omitted, then the name of the current
 *    user is assumed.
 *
 *  $RETURNS$
 *     
 *    .t. if the user is in the selected group, .f. if the user is not.
 *
 *  $DESCRIPTION$
 *     
 *    fn_inGroup() provides a simple "wrapper" around the fn_bndoins()
 *    function ("Is Bindery Object in Set").  This allows you to test
 *    whether or not a user belongs to  a selected user group, as 
 *    defined in the NetWare operating system's bindery.
 *
 *    This can be useful for partitioned security.  For example, you 
 *    can restrict certain parts of an application to users in 
 *    certain user groups.  See the examples below.
 *
 *  $EXAMPLES$
 *     
 *    *  Test current user's group membership for security reasons:
 *
 *         if fn_inGroup( "PAYROLL" )
 *            doPayroll()
 *         else
 *            qout( "Not authorized" )
 *         endif
 *
 *    *  Test a specific user's membership in the "EVERYONE" group:
 *
 *         qout( fn_inGroup( "EVERYONE", "SUPERVISOR" ) )
 *         
 *
 *    *  Test to see if the user on connection 5 is in "PROGRAMMERS":
 *
 *         qout( fn_inGroup( "PROGRAMMERS", 5 ) )
 *
 *  $SEEALSO$
 *    fn_bndoins() 
 *  $INCLUDE$
 *     
 *  $END$
 */


#ifdef FT_TEST
  function main( cGroup, cUser )
     default cUser to fn_whoami(),;
             cGroup to "EVERYONE"

     qout( cUser + " is " + iif( fn_inGroup( cGroup, cUser ), "", " not " ) + ;
           "a member of group " + cGroup )
     return nil
#endif

function fn_inGroup( cGroup, xParm2 )
  local cUser

  do case
     case valtype( xParm2 ) == "N"
        cUser := fn_whoami( xParm2 )
     case valtype( xParm2 ) == "C"
        cUser := xParm2
  otherwise
     cUser := fn_whoami()
  endcase

  return fn_bndoins( cUser, OT_USER, "GROUPS_I'M_IN",;
                     cGroup, OT_USER_GROUP )






