/*
 * File......: DELOBJ.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_delBndO()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Delete Bindery Object
 *  $SYNTAX$
 *
 *     FN_delBndO(cObjectName, nObjectType) => lDeleted
 *
 *  $ARGUMENTS$
 *
 *     <cObjectName> is the name of the Bindery Object that you are
 *		     trying to delete.	Max Length = 47
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *		     describing the defined types are included in the
 *		     NETTO.CH header file.
 *
 *  $RETURNS$
 *
 *     <lDeleted> if object was deleted.
 *
 *  $DESCRIPTION$
 *
 *     This function deletes a bindery object.
 *
 *  $SEEALSO$
 *     fn_creBndO() fn_renBndO()
 *  $EXAMPLES$
 *
 *     lDeleted := FN_delBndO("FRANK", OT_USER)
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType)
    DEFAULT cObject TO "TESTUSER"
    DEFAULT nType TO "1" // OT_USER
    IF FN_delBndO(cObject, Val(nType))
      Qout("Object has been deleted.")
    ELSE
      Qout("Object has not been deleted.")
    ENDIF

  RETURN ( nil )
#endif

FUNCTION FN_delBndO(cObject, nType)

  LOCAL cSend := I2BYTE(51);	      // 33h  API request code
	       + W2HILO(nType);       // nw_int Object type
	       + fn_NameL(cObject,48) // Object name to be deleted

RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS
