/*
 * File......: CRTOBJ.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_CREBNDO()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Create Bindery Object
 *  $SYNTAX$
 *
 *     FN_creBndO(cObjectName, nObjectType, lDynamic, nWrite, nRead)
 *         => lCreated
 *
 *  $ARGUMENTS$
 *
 *     <cObjectName> is the name of the Bindery Object that you are
 *           trying to create.   Max Length = 47
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *           describing the defined types are included in the
 *           NETTO.CH header file.
 *
 *     <lDynamic> if the new object will be dynamic or static. Set it
 *        to true for dynamic and false for static.  Dynamic
 *        objects get deleted when the file server is initialized.
 *
 *     <nWrite> is the object write security as an integer.
 *              The integer indicates who can change the
 *              bindery object.
 *
 *     <nRead> is the object read security as an integer.
 *          The integer indicates who can read and scan
 *             for properties of the bindery object.
 *
 *         Ŀ
 *          Read and Write Security Levels  
 *         Ĵ
 *          0 Anyone                       
 *         Ĵ
 *          1 Logged                       
 *         Ĵ
 *          2 Object                       
 *         Ĵ
 *          3 Supervisor                   
 *         Ĵ
 *          4 Netware Operating System     
 *         
 *
 *
 *  $RETURNS$
 *
 *     <lCreated> logical if object was created or not.
 *
 *  $DESCRIPTION$
 *
 *     This function creates a bindery object.
 *
 *  $SEEALSO$
 *    fn_delBndO() fn_creProp()
 *  $EXAMPLES$
 *
 *     // this will add the object FRANK
 *     lCreated := FN_creBndO("FRANK", OT_USER, .T., 1, 1 )
 *
 *  $END$
 */

#include "netto.ch"

#define NW_LOG 227

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType, nWrite, nRead )
    DEFAULT cObject TO "TESTUSER"
    DEFAULT nType TO "1" // OT_USER
    DEFAULT nWrite TO "1"
    DEFAULT nRead  TO "1"
    IF FN_creBndO(cObject, Val(nType), .T., Val(nWrite), Val(nRead) )
      Qout("Object has been created.")
    ELSE
      Qout("Object has not been created.")
    ENDIF

  RETURN ( nil )

#endif


FUNCTION FN_creBndO(cObject, nType, lDynamic, nWrite, nRead )

  LOCAL cSend := I2BYTE(50);               // 32h API Request Code
          + I2BYTE(Iif(lDynamic, 1, 0));   // Set Dynamic/Static bit
          + I2BYTE((nWrite * 16) + nRead); // Security Level
          + W2HILO(nType);                 // nw_int Object type
          + fn_NameL(cObject,48)           // Object Name

RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS
