/*
 * File......: ACCLEVL.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_bAccLev()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Get Bindery Access Level
 *  $SYNTAX$
 *
 *     FN_bAccLev() => aAccess
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     <aAccess>
 *
 *     Is an array of three elements for a work stations access level
 *     to a file server's bindery.
 *
 *   aAccess[1] is the Property write security as an integer.
 *            The integer indicates who can add properties
 *            to the bindery object.
 *
 *   aAccess[2] is the Property read security as an integer.
 *            The integer indicates who can read and scan
 *            properties for a bindery object.
 *
 *           Ŀ
 *            Read and Write Security Levels  
 *           Ĵ
 *            0 Anyone                       
 *           Ĵ
 *            1 Logged                       
 *           Ĵ
 *            2 Object                       
 *           Ĵ
 *            3 Supervisor                   
 *           Ĵ
 *            4 Netware Operating System     
 *           
 *
 *    aAccess[x,3] is the ObjectId of the logged bindery object.
 *
 *  $DESCRIPTION$
 *
 *    This function returns an array with the read and write security
 *    access levels to the bindery and the logged bindery id.
 *    If an error occurs the function will return nil.
 *
 *  $EXAMPLES$
 *
 *    aSecurity := FN_bAccLev()
 *    QOut(aSecurity[1],aSecurity[2],aSecurity[3])
 *     return ( nil )
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227

#ifdef FT_TEST

  FUNCTION MAIN()
  LOCAL aSecurity
    aSecurity := FN_bAccLev()
    QOut("     Write       Read      Id")
    QOut(aSecurity[1],aSecurity[2],aSecurity[3])
  RETURN ( nil )

#endif

FUNCTION FN_bAccLev
LOCAL cReceive := Space(5)
LOCAL aRetVal
  IF _fnReq(NW_LOG,Chr(70), @cReceive) == ESUCCESS  // 46h API request code
    aRetVal := {Int(BYTE2I(Left(cReceive,1)) / 16); // property_write_security
         , Int(BYTE2I(Left(cReceive,1)) % 16); // property_read_security
         , HILO2L(Substr(cReceive,2,4)) } // user id
  ENDIF

RETURN aRetVal
