/*
 * File......: XACCTNG.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     Overview
 *  $CATEGORY$
 *     Accounting
 *  $ONELINER$
 *     Accounting Services Overview
 *  $SYNTAX$
 *     
 *  $ARGUMENTS$
 *     
 *  $RETURNS$
 *     
 *  $DESCRIPTION$
 *     
 *
 *       In order to use accounting services, the file server
 *       must have accounting installed.  This is accomplished
 *       via SYSCON.
 *
 *       In addition, any object that submits charges must have
 *       its bindery object ID in the file server's ACCOUNT_SERVERS
 *       set property.  Only a supervisor-equivalent user can 
 *       assign a bindery object ID to this property.
 *
 *       Before using any accounting API call, call FN_ACCINST()
 *       first.  This will tell you whether or not accounting is
 *       installed on the current file server. Alternatively, 
 *       you can call FN_ACCINST( nConnID ) to test other file
 *       servers you are connected to.  See the documentation.
 *
 *       NET$ACCT.DAT
 *
 *       When accounting is installed on a server, the network
 *       keeps an audit trail of all accounting transactions.
 *       This audit trail is stored in a file called NET$ACCT.DAT
 *       which resides in the SYS:SYSTEM directory. This is regular
 *       file with normal attributes.
 *
 *       Each time the accounting API's to submit charges or record
 *       notes are called, an entry is written into this audit file.
 *
 *       Charge records, from the FN_SaccChg() function, have the
 *       following format:
 *
 *       Bytes      Description
 *       -----      -------------
 *        0-2       Record length -2 (excludes 2 bytes for length)
 *        2-4       Server bindery object id
 *        6-6       Time stamp, six single bytes for
 *                       Year-1900
 *                       Month
 *                       Day
 *                       Hour
 *                       Minute
 *                       Second
 *       12-1       Record type (1=Charge record)
 *       13-1       Completion code (0=Successful,194=Credit exceeded)
 *       14-2       Service type (Normally bindery object type of server)
 *       16-4       Client bindery object id (who was charged for services)
 *       20-4       Amount charged
 *       24-2       Comment type
 *       26-x       Text of comment
 *
 *       The comment field contains a string of binary information
 *       packed together.  The string's contents vary depending on
 *       the comment type.  (See the section on Comment types below)
 *
 *       Note records, from the FN_SaccNote() function, have the
 *       following format:
 *
 *       Bytes      Description
 *       -----      -------------
 *        0-2       Record length -2 (excludes 2 bytes for length)
 *        2-4       Server bindery object id
 *        6-6       Time stamp, six single bytes for
 *                       Year-1900
 *                       Month
 *                       Day
 *                       Hour
 *                       Minute
 *                       Second
 *       12-1       Record type (2=Note record)
 *       13-1       Reserved
 *       14-2       Service type (Normally bindery object type of server)
 *       16-4       Client bindery object id (who was charged for services)
 *       20-2       Comment type
 *       22-x       Text of comment
 *
 *       The comment field contains a string of binary information
 *       packed together.  The string's contents vary depending on
 *       the comment type.  (See the section on Comment types below)
 *
 *       NET$REC.DAT
 *
 *       This file contains the formatting instructions for all comment
 *       types. NET$REC.DAT is also stored in SYS:SYSTEM as a regular
 *       file.  It's structure is shown here:
 *
 *       Bytes      Description
 *       -----      -------------
 *        0-2       Record length -2 (excludes 2 bytes for length)
 *        2-2       Comment type
 *        4-1       Number of fields in this comment type
 *        5-?       Data types of each field in the comment string
 *        ?-x       Length of the format string
 *        ?-y       Actual format string.
 *
 *       For example, the format record for DISK STORAGE CHARGE NOTE
 *       would look like the following:
 *
 *       Ŀ
 *       48 223342%lu disk blocks stored for %lu half-hours.
 *       
 *
 *       Comments and Comment Types
 *
 *       Novell supports the following comment types in a charge record.
 *       Developers of Netware applications may create additional comment
 *       types which would have different numbers.
 *
 *       Comment type 1 - Connect time charge
 *       This comment type indicates the number of minutes that a station
 *       was connected to the server, the number of packets sent, and the
 *       number of disk operations.
 *
 *       Bytes      Description
 *       -----      -------------
 *        0-4       Connect time in minutes
 *        4-4       Number of packet requests
 *        8-6       Number of bytes read
 *       14-6       Number of bytes written
 *
 *
 *       Comment type 2 - Disk storage charge
 *       This comment type charges for the number of storage blocks owned
 *       and the amount of time they were owned for (in half-hour increments).
 *
 *       Bytes      Description
 *       -----      -------------
 *        0-4       Blocks owned
 *        4-4       Number of half hours owned
 *
 *       Comment type 3 - Login to server note
 *       This comment type records the station number whenever an object
 *       logins to the server.
 *
 *       Bytes      Description
 *       -----      -------------
 *        0-4       Network address
 *        4-6       Node login to
 *
 *       Comment type 4 - Logout from server note
 *       This comment type records the station number whenever an object
 *       log outs from a server.
 *
 *       Bytes      Description
 *       -----      -------------
 *        0-4       Network address
 *        4-6       Node logged out from
 *
 *       Comment type 5 - Account locked note
 *       This comment type records the station number whenever an intruder
 *       detection event occurs.  The client number field in the note record
 *       indicates the object number that has been locked out.
 *
 *       Bytes      Description
 *       -----      -------------
 *        0-4       Network address
 *        4-6       Node logged out from
 *
 *       Comment type 6 - Server time changed note
 *       This comment type records whenever the time is changed on the
 *       file server.  The client number field in the note record indicates
 *       the user that made the time change. The comment indicates the new
 *       date that the server was changed to.
 *
 *       Bytes      Description
 *       -----      -------------
 *        0-6       Time stamp, six single bytes for
 *                       Year-1900
 *                       Month
 *                       Day
 *                       Hour
 *                       Minute
 *                       Second
 *
 *
 *
 *       A sample report server
 *
 *       Assume that you have a Clipper application that processes
 *       some files and produces a laser printed report. This program
 *       runs at night and reads a DBF file to determine what to print.
 *       The DBF file contains the requesting user's object name, the
 *       directory to run the report in, and the report name.  It also
 *       contains a status field that gets filled in after the report
 *       has run.
 *
 *       The following code illustrates the Clipper program to process
 *       the requests database and run the reports. It bills the user
 *       for these reporting services and denies service if the user id
 *       does not have sufficient credit.
 *
 *
 *       #define  COST_PER_REPORT      5.00
 *       #define  ACCOUNT_BALANCE     aStatus[1]
 *       #define  CREDIT_LIMIT        aStatus[2]
 *
 *       procedure main
 *       LOCAL aStatus
 *       LOCAL cMsg
 *       LOCAL nResult
 *       use REQUESTS exclusive
 *       go top
 *       do while !eof()
 *          //
 *          // Check if user has sufficient funds
 *          //
 *          aStatus := Fn_GAccStat( REQUESTS->username,1 )
 *          cMsg    := "Report run ok..."
 *          if !empty(aStatus)
 *             if ACCOUNT_BALANCE > CREDIT_LIMIT
 *                nResult := FN_sAccHold( REQUESTS->username,;
 *                                        1,COST_PER_REPORT )
 *                if nResult == 0
 *                   //
 *                   Do_Report( REQUESTS->dir,REQUEST->rpt_name )
 *                   //
 *                   FN_sAccChg( REQUESTS->username,1,1,;
 *                               COST_PER_REPORT,;
 *                               COST_PER_REPORT,1,;
 *                               { 5,100,100,100 } )
 *                else
 *                   cMsg := "Problem ("+alltrim(str(nResult))+") occurred"
 *                endif
 *             else
 *                cMsg := "Over credit limit..."
 *             endif
 *          else
 *             cMsg := "No account balance"
 *          endif
 *          replace REQUESTS->status with cMsg
 *          select REQUESTS
 *          skip +1
 *       enddo
 *       close databases
 *
 *
 *
 *  $EXAMPLES$
 *     
 *  $SEEALSO$
 *     
 *  $INCLUDE$
 *     
 *  $END$
 */

static function xacctng()
	return nil
