/*
 * File......: GACCSTA.PRG
 * Author....: Joseph D. Booth
 * CIS ID....: 72040,2112
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Joseph D. Booth and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_gAccStat()
 *  $CATEGORY$
 *     Accounting
 *  $ONELINER$
 *     Get Account Status of an Object
 *  $SYNTAX$
 *     aStatus := FN_gAccStat( cObjName,nObjType )
 *  $ARGUMENTS$
 *     <cObjName> is the name of the bindery object
 *     <nObjType> is the bindery object's type
 *
 *  $RETURNS$
 *
 *      <aStatus> is an array containing three elements as follows:
 *
 *         aStatus[1] : Account Balance (numeric)
 *         aStatus[2] : Credit Limit (numeric)
 *         aStatus[3] : Array of holds (array)
 *                      { nObject_id,nHold_Amt }
 *
 *     If the call was successful the status array will be updated
 *     accordingly, otherwise an empty array is returned.
 *    
 *     If an empty array is returned, you can examine the return
 *     code from FN_ERROR() for one of the following:
 *
 *             192      No account privileges
 *
 *                      The object that is making this call must
 *                      be a member of the SET property 
 *                      "ACCOUNT_SERVERS" for this file server,
 *                      and accounting must be installed.
 *
 *             193      No account balance
 *     
 *  $DESCRIPTION$
 *     
 *  This function returns the status of the account status for given
 *  bindery object.  The return pack holds the following information:
 *
 *    Account Balance:  Current balance in units of money, usually cents
 *    Credit Limit   :  Minimum balance, if negative, user can request
 *                      more services than the account balance allows.  If
 *                      positive, you can ensure that money is alway left
 *                      in the account.  Once the account balance drops
 *                      below the credit limit, services will be denied.
 *    Server holds   :  Services (other bindery objects) can place holds
 *                      on an account.  A hold reserves a certain amount
 *                      of money for the service until the service bills
 *                      for it.  An object can have up to 16 holds against
 *                      it.  This array contains the object id and the amount
 *                      of the hold for up to the 16 service holds.
 *
 *  $EXAMPLES$
 *     
 *      #define  ACCOUNT_BALANCE     aResult[1]
 *      #define  CREDIT_LIMIT        aResult[2]
 *
 *
 *      procedure PrintJob
 *      if oktorun(cWho,nType)
 *         //
 *         // Run the printer job
 *         //
 *      else
 *         Alert( "Insufficient funds" )
 *      endif
 *      return
 *
 *
 *      function oktorun(cWho,nType)
 *      LOCAL   aResult:={}, is_ok := .F.
 *      aResult := FN_gAccSta(cWho,nType)
 *      if !empty( aResult )
 *         is_ok := ACCOUNT_BALANCE > CREDIT_LIMIT
 *      endif
 *
 *      return NIL
 *
 *  $SEEALSO$
 *      FN_sAccChg() FN_sAccHold() FN_sAccNote()
 *  $INCLUDE$
 *     
 *  $END$
 */


#include "ftint86.ch"
#include "netto.ch"

#define GETACCOUNTSTAT  150      /* 96h */
#define NW_ACCT_CALL    227      /* E3h */


function fn_gaccsta(cObject,nType)
  LOCAL cRequest, cReply, aStat := {}
  LOCAL x,y

  default nType to  OT_USER

  cRequest := I2BYTE( GETACCOUNTSTAT )+;
              W2HILO( nType )+;
              FN_NAMEL( cObject )
  cReply   := repl( chr(0), 258 )

  if _fnReq( NW_ACCT_CALL, cRequest, @cReply ) == 0
     Aadd( aStat, HILO2L( substr(cReply,1,4) ) )
     Aadd( aStat, HILO2L( substr(cReply,5,4) ) )
     for x:= 130 to 252 step 8
        if ( y:= HILO2L(substr(cReply,x,4)) ) > 0
           Aadd( aStat, { y, HILO2L(substr(cReply,x+4,4)) } )
        endif
     next

  endif

  return aStat
