/*
 * File......: ACINST.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      fn_accInst()
 *  $CATEGORY$
 *      Accounting
 *  $ONELINER$
 *      Is Accounting installed?
 *  $SYNTAX$
 *     
 *      fn_accInst( [<connId>] ) -> lInst
 *
 *  $ARGUMENTS$
 *
 *      <nConnID> (optional) - the connection ID of the file server
 *      for which you are testing whether or not accounting is 
 *      installed.  Defaults to your current preferred connection ID.
 *
 *      For more information on connection id's, see the fn_connid()
 *      function.
 *
 *  $RETURNS$
 *
 *      .t. if accounting is installed; .f. if it isn't.
 *
 *  $DESCRIPTION$
 *
 *      This call determines whether or not accounting is installed
 *      on a particular file server.  
 *
 *  $EXAMPLES$
 *
 *      qout( "Accounting is" + iif( fn_accInst(), "", " not" ) + ;
 *            " installed." )
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

#ifdef FT_TEST
   function main()
      return qout( "Accounting is" + iif( fn_accInst(), "", " not" ) + ;
                   " installed." )
#endif

function fn_accInst( nConnID )
   local nOld, cNm, lAcct := .f., lProp := .f.

   nOld := fn_pfconid()
   default nConnID to nOld

   fn_spfcid( nConnID )

   cNm   := fn_fsname()[ nConnID + 1 ]
   lAcct := ( fn_getFSI()[11] == 1 )      // Accounting version
   lProp := !( fn_scaprop( cNm, OT_FILE_SERVER, "ACCOUNT_SERVERS" ) == nil )

   fn_spfcid( nOld )
   return ( lAcct .and. lProp )









