/*

   NetPrompt   
   
   Resident Module
   
   NPR.C
   3/18/92

   F. Brett Platko

   This module contains the resident code for the TSR.
   
*/   


#include "cr.h"			  
#include "lm.h"
#include "sio.h"

struct REGW regs;

char  wBuff [46] = {0};

byte  rCode;                                 // Global Return code (byte).

char  serverName   [ 48];
char  volumeName   [ 16];

int   i;                                     // General Purpose counter.

word  orgPromptSize;
  
char  searchKey [  ] = "PROMPT=";
char  localVar  [  ] = "[LOCAL] ";

char  dosEnvVar [60] = {0};

char  promptStr [48] = "$P$Q$G";

byte far *fpMasterEnv;                       // Pointer to Master Environment.

word     mEnvSize;                           // Size of Master Environment Data.

// Interrupt Service for DOS Interrupt 0x21. 

#define f_ss (dword)(_int_frame->saved_ss)   // Foreground SS register. 
#define f_sp        (_int_frame->saved_sp)   // Foreground SP register. 

struct trap_rec tr = {0,                     // Trap control record.
                      0,                     // Holds Old Interrupt Vector.
                      0x21,                  // Interrupt Vector to be trapped.
                      0,                     // Internal
                      0,                     // Internal
                      0,                     // Internal
                      1};                    // Pass control to old interrupt if busy.
void  ProcessPrompt  (void)               // Inserts the new prompt in table.
{
   byte  temp = 0x00;

   int freeEnv;                              // Bytes of free env space.
   int promptLen;                            // Size of new prompt string.
   static int n;
   char termData  [2] = {0};

   word mEnvCurSize;                         // Env Size, work copy.

   byte far *fpEndEnvData;                   // Far Pointer to end of data in Env block.
   byte far *fpTermData;                     // Far Pointer to 0x00 0x00 Search block. 
    byte far *fpSearchKey;                    // Far Pointer to PROMPT= string. 
   byte far *fpDosEnvVar;                    // Far Pointer to new prompt string.
   byte far *fpTempPtr;                      // Far Work Pointer.

   byte *pTempPtr;                           // Work Pointer
   
   byte  curDrive;                           // Current DOS drive letter. 

   // ----------------- Get Drive Connection ID -------------------------

   curDrive = get_cur_drive();               // Get the current drive letter. 

   regs.ax  =  0xEF02;                       // GetDriveConnectionID (NetWare)

   int21 (&regs, &regs);

   // The Drive connection ID table contains 32 entries of one byte each,
   // 26 Letter, and 6 special. Each entry contains the connection ID 
   // (1-8) of the server that is associates with that drive. A value of 
   // 0 indicates that the drive is not mapped to a file server (local 
   // drive or drive not used.)

   // ES:SI point to the Workstation Shell's Drive Connection ID Table.

   regs.si = regs.si + (curDrive - 0x41);       // Position offset into table.
                                                // curDir contains the ASCII letter
                                                //  so we must move it to 0 base.

   rCode = ofsg_r1(regs.si, regs.es);           // Read the byte value.
   
   // rCode now contains the file server number.

   if (rCode == 0x00)                           // It is a Local Drive.
   {
      strcpy (dosEnvVar, searchKey);
      strcat (dosEnvVar, localVar);
      strcat (dosEnvVar, promptStr);
   }
   else
   {
      // ---------------- Get File Server Name --------------------

      regs.ax  =  0xEF04;                       // GetFileServerName (NetWare)

      int21 (&regs, &regs);

      // The File Server Name Table consists of eight entries (1-8) that are each
      // 48 bytes long.  Each entry is this table can contain a null-terminated 
      // server name.  

      // The first server in the File Server Table corresponds to the first entry
      // in the Connection ID Table. The connection ID of a file server is the
      // physical offset (1-8) that the file server occupies in these tables.

      // ES:SI points to the Shell's Server Name Table.

      regs.si = regs.si + ((rCode -1) * 48);     // Position offset into table.

      i = 0x00;

      // Copy Server Name.

      while ((temp = ofsg_r1(regs.si, regs.es)) != 0x00) // Copy server name.
      { 
         serverName[i] = temp;
         regs.si ++;
         i ++;
      }

      serverName[i] = '\0';                     // Add terminating null.

      // serverName now contains the target drive's host server name.
      
      // ---------------- Get Drive (Volume) Handle -------------------

      regs.ax = 0xEF00;                            // GetDriveHandleTable (NetWare)

      int21 (&regs, &regs);

      // The Drive Handle Table contains 32 entries of one byte each. If a drive
      // has been assigned a directory handle on a file server, the directory
      // handle's number appears in this table at the corresponding drive letter
      // position.

      // A value of 0 indicates that the drive is not mapped to a network 
      // directory.  The directory handle can be used to refer to the directory
      // path mapped to the drive letter.

      // ES:SI points to the Shell's Drive Handle Table.

      regs.si = regs.si + (curDrive - 0x41);        // Position offset into table.
                                                    // curDir contains the ASCII letter
                                                    //  so we must move it to 0 base.

      rCode = ofsg_r1(regs.si, regs.es);            // Read the byte value.

      // rCode now contains the drive handle for the network volume.
  
      if (rCode != 0x00)
      {
         // ------------------ Get Volume Info --------------------

         // This call returns information about a volume.

         // On Entry:   AH    = E2h
         //             DS:SI = Request Buffer Address
         //             ES:DI = Reply Buffer Address

         // On Return:  AL    = Completion Code, 0x00 == Successful.

         regs.ax = 0xE200;             // GetVolumeInfoWithHandle.

         wBuff[0] = 0x02;              // Length of Request Buffer (-2)   
         wBuff[2] = 0x15;              // Function 15 (E2/15)
         wBuff[3] = rCode;             // Directory Handle of Volume.

         // Define Send Buffer Location.

         regs.ds = _cdata;             // _cdata points to TSR's Data Segment.
         regs.si = wBuff;              // Offset of work buffer variable.

         // Define Reply Buffer Location.

         regs.es = _cdata;
         regs.di = wBuff;  

         int21 (&regs, &regs);

         // Reply Buffer:  Offset   Content              Type     Order
         //                   0     Length (-2)          word     lo-hi
         //                   2     Sectors Per Block    word     hi-lo
         //                   4     Total Blocks         word     hi-lo
         //                   6     Available Blocks     word     hi-lo
         //                   8     Total Dir Slots      word     hi-lo
         //                  10     Available Dir Slots  word     hi-lo
         //                  12     Volume Name          byte[16]   -
         //                  28     Is Volume Removable  word     hi-lo
   
         if ((regs.ax & 0x0000) == 0x00)  // Successful
         {      
            for (i = 12; i < 28; i ++)
            {
               volumeName[i-12] = wBuff[i];           // Copy the VolumeName.
            }
            
            // Build Prompt string.

            strcpy (dosEnvVar, searchKey);
            
            strcat (dosEnvVar, "[");
            strcat (dosEnvVar, serverName);
            strcat (dosEnvVar, "/");
            strcat (dosEnvVar, volumeName);
            strcat (dosEnvVar, "] ");
            strcat (dosEnvVar, promptStr);

         }
      }
   }  

   // ----------------  Plug New Prompt Into Env Block --------------------
   
   mEnvCurSize = 0x00;

   fpTermData = MK_FP (_cdata, termData);       // Create Far Pointer to Termination Code.

   fpTempPtr = fmem_find ((word) 2,             // Size of search string.
                                 fpTermData,    // Search string.
                                 mEnvSize,      // Size of search area.
                                 fpMasterEnv);  // Where to search.

   mEnvCurSize = (word) fpTempPtr;              // Location of data termination string.

   // Since we are working with the master environment, there is no additional
   // scanning required. Non-Commandline Environments would need to scan past 
   // the Full Path specification that follows the environment variables.

   freeEnv = mEnvSize - mEnvCurSize;            // Calculate Free Space         
   
   // Now we scan for the location of the PROMPT= string. 

   fpSearchKey = MK_FP (_cdata, searchKey);     // Create far pointer to Prompt= string.

   fpTempPtr = fmem_find ((word) 7,                  
                                 fpSearchKey,        
                                 mEnvCurSize,        
                                 fpMasterEnv);       

   if (fpTempPtr == 0x0000)                     // PROMPT is not defined so we
   {                                            // will add it to the end of the env.
      fpTempPtr = fpMasterEnv + mEnvCurSize + 1;
      goto APPEND;
   }

   orgPromptSize = fstr_len (fpTempPtr);        // Get current size of prompt string.   

   // -------- Strip out orginal prompt string from env data (PACK) -------

   n = (mEnvCurSize - (word) fpTempPtr) - orgPromptSize;       // size of packed environment.

   for (i = 0x00; i < n; i ++)
   {
      *fpTempPtr ++  = *((fpTempPtr + orgPromptSize) + 1);     // Relocate data.
   }

   // ----------- Now append new Prompt string to env data ---------------

   APPEND:

   fpDosEnvVar = MK_FP (_cdata, dosEnvVar);     // Create far pointer to new prompt string.

   n = str_len(dosEnvVar);                      // Size of new prompt string.

   for (i = 0x00; i < n; i ++)
   {
      *fpTempPtr ++ = *fpDosEnvVar ++;          // Annotate Prompt string to end of env data.
   } 

   *(fpTempPtr ++) = 0x00;                      // Add terminating nulls.
   *(fpTempPtr ++) = 0x00;                 

}

isr21 (arg)
{
   static word f_ax;                      // AX value in interrupt call.
   
   // Get DOS 21 Function Call values.

   f_ax = ((struct glob_stk far *)((f_ss << 16) + f_sp)) -> ax; 

   if ((f_ax & 0x1900) == 0x1900)         // Function is 19 Hex (Get Default Disk Drive)
   {
      if (at_dos_prompt())                // If we are at the DOS prompt
      {
         ProcessPrompt();                 // Do new prompt.
      }
   }

   return(arg);                           // Pass the interrupt 21 value on.
}

