;==========================================================================
;           :
; Name      : Address.PPS
;           :
; Syntax    : *$INCLUDE:Address.INC
;           :
; Copyright : (c) 1994 Tranquility Base
;           :
; Version   : 1.0
;           :
; Action    : This is a sub-routine to get a FidoNet address from a user. 
;           :
; Notes     : You MUST have issued a GETUSER before this routine!
;           :
;==========================================================================
;
; Now look to see if the SYSOP has created an ADDRESS prompt file.
; If so then display it.  If not then Ask for the Address.
; NOTE:  The ADDR* file should NOT end with a LF.  The last line of
; the file IS the prompt for the Address.  You need to make sure and leave
; at lease 32 spaces at the end of your prompt for them to enter the 
; address in.
;

If ((U_EXPERT=FALSE) && (EXIST(PPEPATH()+"ADDR*.*"))) Then
   DispFile PPEPath()+"ADDR",SEC+GRAPH+LANG
   INPUTTEXT "",ThisAddress,@X0F,30
Else
   INPUTTEXT "@X0FAddress to Send To (ENTER)=Abort ?",ThisAddress,@X0F,30
EndIF

NEWLINE


;
; Check for an empty address and bail if found
;
If (Len(Trim(ThisAddress," "))<1) Then
   Goto END
EndIf


;
; Now Check for a VALID address.
; We are going to take the address apart just to make sure that all the
; parts are there.    
;
ThisAddress=Trim(ThisAddress," ")

For Counter=1 to Len(ThisAddress)
   WorkString=Mid(ThisAddress,Counter,1)

   If (WorkString=":") Then
      ;      
      ; If this is a COLON then the Accumulator holds the ZONE
      ;
      Zone=S2I(Accumulator,10)
      Accumulator=""
      GotZone=1

   ElseIf (WorkString="/") Then
      ;      
      ; If this is a SLASH then the Accumulator holds the NET
      ;
      Net=S2I(Accumulator,10)
      Accumulator=""
      GotNet=1

   ElseIf (WorkString=".") Then
      ;      
      ; If this is a PERIOD and we don't already HAVE a NODE 
      ; then the Accumulator holds the NODE
      ;
            
      If (GotNode=0) THEN
         Node=S2I(Accumulator,10)
         Accumulator=""
         GotNode=1
      Else
         ;      
         ; If this is a PERIOD and we DO already have a NODE then 
         ; the Accumulator holds the domain
         ;
         Accumulator=Accumulator+WorkString
      EndIf

   ElseIf (WorkString="@") Then
      ;      
      ; If this is an @ then the Accumulator holds a POINT
      ;
      Point=S2I(Accumulator,10)
      Accumulator=""
      GotPoint=1

   Else
      ;
      ; Anything else is just part of the address.
      ;
      Accumulator=Accumulator+WorkString
   EndIf

Next Counter

If (Len(Accumulator)>0) Then
   ;
   ; If we have somthing left in the accumulator then let's figure
   ; out what it is.
   ;
   If (GotNode>0) Then
      ;
      ; If GotNode > 0 then it's not the Node number. Let's
      ; check to see if it's a PONT
      ;
      If (GotPoint>0) Then 
         ;
         ; If GotPoint > 0 then We've already got a Point
         ; so it HAS to be the Domain name
         ;
         Organization=Trim(Accumulator," ")
         GotOrg=1
      Else
         ;
         ; If we DON'T have a Point number then let's assume 
         ; that this is a POINT number.
         ;
         Point=S2I(Accumulator,10)
         GotPoint=1
      EndIf
   
   Else
      ;
      ; If we don't have a NODE number then what's left in the Accumulator
      ; MUST be the NODE number.
      ;
      Node=S2I(Accumulator,10)
      GotNode=1
   EndIf

EndIf

;
; Now that we have it in pieces, let's check each piece
; First : Let's check the ZONE number.  If GotZone=0 then set
;         ZONE number to the Default ZONE.
If (GotZone=0) ZONE=DefaultZone


; Second: If Check the GotNet, if GotNet says that we DO NOT have
;         a net then set the net to the default net.
If (GotNet=0) Net=DefaultNet


;
; Third : Check the Node Number
;
If (GotNode=0) Then
   ; If we don't have a NODE number then they obviously 
   ; typed something in wrong.  If this is the case then
   ; tell the user and allow them to change it.
   PRINTLN "Your address is improperly formatted, please try again."
   NewLine
   Goto Address
EndIf


;
; Now that we have checked each part for viability, let's
; put it all back together.
;
ThisAddress=Trim(I2S(Zone,10)," ")
ThisAddress=ThisAddress+":"+Trim(I2S(Net,10)," ")
ThisAddress=ThisAddress+"/"+Trim(I2S(Node,10)," ")


;
; If we have a Point address then add it in.
;
If (GotPoint=1) Then
   ThisAddress=ThisAddress+"."+Trim(I2S(Point,10)," ")
EndIf


;
; If we have a domain then add it in.
;
If (GotOrg=1) Then
   ThisAddress=ThisAddress+"@"+Organization
EndIf


