{$F+}
{$N+}
Program NDDESVR;
Uses
  WinTypes, WinProcs, Objects, OWindows, ODialogs, Win31, DDEML, NDDEAPI, Winnet,
  Strings, BWCC;

Const
  { NDDE Share infoemation }

  Service_Name : PChar = 'nddesvr';
  Share_Name : PChar = 'NDDESVR$';
  App_Name : PChar = 'NDDESVR';
  Topic_Name : PChar = 'BORLAND';
  Item_Name : PChar = 'Products';

  AppTitle : PChar = 'Network DDE Server';

  CM_U_About = $100;

Type
{ TNDDESrWnd }
  PNDDESrWnd = ^TNDDESrWnd;
  TNDDESrWnd = object(TWindow)
    idInst : LongInt;
    Conv :  hConv;
    tfLoop : Boolean;
    hszShare, hszService, hszTopic, hszItem : hSz;
    CallBack : TCallBack;

    Constructor Init(AParent : PWindowsObject; ATitle : PChar);
    Destructor Done; virtual;
    Procedure SetUpWindow; virtual;
    Procedure WMSysCommand(var Msg : TMessage); virtual WM_First + WM_SysCommand;
    Procedure WMQueryOpen(var Msg : TMessage); virtual WM_First + WM_QueryOpen;
    Function MatchTopicAndService(ATopic, AService : hSz) : Boolean; virtual;
    Function MatchTopicAndItem(ATopic, AItem : hSz) : Boolean; virtual;
    Function WildConnect(hsz1, hsz2 : hSz; wFmt : Word) : HDDEData; virtual;
    Function DataRequested(wFmt : Word) : HDDEData; virtual;
    Procedure UpdateData;
  Private
    LocalName : Array[0..50] of char;
  end;

Var
  ConvWindow : PNDDESrWnd;

Function CallBackProc(CallType, Fmt : Word; Conv : hConv; HSz1,HSz2 : HSz;
                      hData : HDDEData; Data1,Data2 : LongInt) : HDDEData; export;
var
  szTemp : Array[0..128] of char;
  iSize : Integer;
begin
  CallBackProc := 0;
  Case CallType of
    XTYP_ADVREQ : begin
      if ConvWindow^.MatchTopicAndItem(hsz1, hsz2) then
      begin
        CallBackProc := ConvWindow^.DataRequested(Fmt);
      end;
    end;

    XTYP_ADVSTART : begin
      if (NOT ConvWindow^.tfLoop) AND (ConvWindow^.MatchTopicAndItem(hsz1, hsz2)) then
      begin
        ConvWindow^.tfLoop := TRUE;
        CallBackProc := 1;
      end
      else
        CallBackProc := 0;
    end;

    XTYP_ADVSTOP : begin
      if (ConvWindow^.tfLoop) AND (ConvWindow^.MatchTopicAndItem(hsz1, hsz2)) then
      begin
        ConvWindow^.tfLoop := FALSE;
        CallBackProc := 1;
      end;
    end;

    XTYP_CONNECT : begin
      if (ConvWindow^.Conv = 0) then
      begin
        if ConvWindow^.MatchTopicAndService(hsz1, hsz2) then
          CallBackProc := 1;
      end
      else
        CallBackProc := 0;
    end;

    XTYP_CONNECT_CONFIRM : begin
      ConvWindow^.Conv := Conv;
    end;

    XTYP_DISCONNECT : begin
      If (Conv = ConvWindow^.Conv) then
      begin
        ConvWindow^.Conv := 0;
        ConvWindow^.tfLoop := FALSE;
        CallBackProc := 0;
      end;
    end;

    XTYP_ERROR : begin
      MessageBox(ConvWindow^.hWindow, 'A Critical DDE error has occured.', Application^.Name, MB_ICONINFORMATION);
      CallBackProc := 0;
    end;

    XTYP_EXECUTE : begin
      CallBackProc := DDE_FNOTPROCESSED;
    end;

    XTYP_POKE : begin
      strCopy(szTemp, 'The Server received : '+#13);
      iSize := StrLen(szTemp);
      DDEGetData(hData, @szTemp[iSize], Sizeof(szTemp)-iSize, 0);
      MessageBox(GetFocus, szTemp, Application^.Name, MB_ICONINFORMATION);
      CallBackProc := DDE_ACK;
    end;

    XTYP_REQUEST : begin
      if ConvWindow^.MatchTopicAndItem(hsz1, hsz2) then
      begin
        CallBackProc := ConvWindow^.DataRequested(Fmt);
      end;
    end;

    XTYP_WILDCONNECT : begin
      if ConvWindow^.MatchTopicAndItem(hsz1, hsz2) then
      begin
        CallBackProc := ConvWindow^.WildConnect(hsz1, hsz2, Fmt);
      end;
    end;
  end;
end;

Constructor TNDDESrWnd.Init(AParent : PWindowsObject; ATitle : PChar);
var
  TempName : Array[0..50] of char;
  ShareInfo : TNDDEShareInfo;

  uRet : Word;

const
  Pass1 : PChar = 'FULL';
  Pass2 : PChar = 'NOSTART';

var
  NoOfBytes : LongInt;
  NoAdded : Word;

begin
  inherited Init(AParent, ATitle);
  Attr.Style := ws_SysMenu;

  { Get our local Name }

  NDDEGetNodeName(TempName, Sizeof(TempName));
  { Will need // added if not already there }

  if (TempName[0] <> '\') OR (TempName[1] <> '\') then
    strcopy(LocalName, '\\')
  else
    strcopy(LocalName, '');
  strcat(LocalName, TempName);

  { UpDate the share information in System.ini }
  NDDEShareDel(NIL, Share_Name, 0); { Delete it first, this way it is always upto date }

  FillChar(ShareInfo, Sizeof(TNDDEShareInfo), 0);
  With ShareInfo do
  begin
    lstrcpy(szShareName, Share_Name);
    lpszTargetApp :=  Service_Name;
    lpszTargetTopic := Topic_Name;
    lpszItem := NIL;
    lpbPassWord1 := PByte(Pass1);
    lpbPassWord2 := PByte(Pass2);
    cbPassword1 := 4;
    cbPassword2 := 7;
    dwPermissions1 := NDDEACCESS_ExcludeExecute;
    dwPermissions2 := NDDEACCESS_Request + NDDEACCESS_Poke + NDDEACCESS_Advise;
  end;

  uRet := NDDEShareAdd(NIL, 2, @ShareInfo, Sizeof(TNDDEShareInfo));
  If uRet<>NDDE_No_Error then
    PostQuitMessage(0);
end;

Destructor TNDDESrWnd.Done;
begin
  if Conv <> 0 then
  begin
    DDEDisconnect(Conv);
    Conv := 0;
  end;
  if idInst <> 0 then
  begin
    DDENameService(idInst, hszService, 0, DNS_UNREGISTER);
    if hszService <> 0 then
    begin
      DDEFreeStringHandle(idInst, hszService);
      hszService := 0;
    end;
    if hszTopic <> 0 then
    begin
      DDEFreeStringHandle(idInst, hszTopic);
      hszTopic := 0;
    end;
    if hszItem <> 0 then
    begin
      DDEFreeStringHandle(idInst, hszItem);
      hszItem := 0;
    end;
    DDEUnInitialize(idInst);
    idInst := 0;
  end;
  if @CallBack<>NIL then
  begin
    FreeProcInstance(@CallBack);
    @CallBack := NIL;
  end;
  inherited done;
end;

Procedure TNDDESrWnd.SetupWindow;
var
  Menu : hMenu;
Const
  TempServ : PChar = '%s\%s';

var
  TempArray : Array[0..1] of LongInt;
  szTemp : Array[0..100] of Char;
  hszTemp : hSz;


begin
  inherited SetupWindow;
  idInst := 0;
  Conv := 0;
  tfLoop := FALSE;
  hszService := 0;
  hszTopic := 0;
  hszItem := 0;
  hszShare := 0;
  @CallBack := MakeProcInstance(@CallBackProc, hInstance);
  if @CallBack<>NIL then
  begin
    if DDEInitialize(idInst, CallBack,  APPClass_Standard + CBF_Skip_Registrations
                     + CBF_Skip_Unregistrations, 0) = DMLERR_NO_ERROR then
    begin
      hszTopic := DDECreateStringHandle(idInst, Topic_Name, CP_WINANSI);
      hszItem := DDECreateStringHandle(idInst, Item_Name, CP_WINANSI);
      hszService := DDECreateStringHandle(idInst, App_Name, CP_WINANSI);
      if (hszService <> 0) AND (hszTopic <> 0) AND (hszItem <> 0) then
      begin
        if DDENameService(idInst, hszService, 0, DNS_REGISTER) <> 0 then
        begin
          Menu := GetSystemMenu(hWindow, FALSE);
          AppendMenu(Menu, MF_BYCOMMAND + MF_SEPARATOR, $FFFF, '');
          AppendMenu(Menu, MF_BYCOMMAND + MF_STRING, CM_U_ABOUT, '&About NDDESvr');
        end
        else
        begin
          MessageBox(hWindow, 'Registration failed.', AppTitle, MB_IconStop);
          PostQuitMessage(0);
        end;
      end
      else
      begin
        MessageBox(hWindow, 'String creation failed.', AppTitle, MB_IconStop);
        PostQuitMessage(0);
      end;
    end
    else
    begin
      MessageBox(hWindow, 'Initialization failed.', AppTitle, MB_IconStop);
      PostQuitMessage(0);
    end;
  end
  else
  begin
    MessageBox(hWindow, 'Setup of CALLBACK failed', AppTitle, MB_IconStop);
    PostQuitMessage(0);
  end;
end;

Procedure TNDDESrWnd.WMSysCommand(var Msg : TMessage);
begin
  if (Msg.wParam AND $FFF0) = CM_U_ABOUT then
  begin
    MessageBox(hWindow, 'Network DDE Server'#13' Copyright 1993 G.T. Swindell'#13' Copyright 1992 Borland International',
               'About NDDESVR', MB_ICONINFORMATION );
  end
  else
    DefWndProc(Msg);
end;

Procedure TNDDESrWnd.WMQueryOpen(var Msg : TMessage);
begin
  Msg.Result := 0;
end;

Function TNDDESrWnd.MatchTopicAndService(ATopic, AService : hsz) : Boolean;
var
  TopicTemp,
  ItemTemp : Array[0..50] of Char;
begin
  DDEQueryString(idInst, ATopic, @TopicTemp, Sizeof(TopicTemp), CP_WINANSI);
  DDEQueryString(idInst, AService, @ItemTemp, Sizeof(ItemTemp), CP_WINANSI);
  MatchTopicAndService := FALSE;
  if DDECmpStringHandles(hszTopic, ATopic) = 0 then
      MatchTopicAndService := TRUE;
end;

Function TNDDESrWnd.MatchTopicAndItem(ATopic, AItem : hsz) : Boolean;
var
  TopicTemp,
  ItemTemp : Array[0..50] of Char;

begin
  MatchTopicAndItem := FALSE;
  DDEQueryString(idInst, ATopic, @TopicTemp, Sizeof(TopicTemp), CP_WINANSI);
  DDEQueryString(idInst, AItem, @ItemTemp, Sizeof(ItemTemp), CP_WINANSI);
  if DDECmpStringHandles(hszTopic, ATopic) = 0 then
  begin
    if DDECmpStringHandles(hszItem, AItem) = 0 then
      MatchTopicAndItem := TRUE;
  end;
end;

Function TNDDESrWnd.WildConnect(hsz1, hsz2 : hSz; wFmt : Word) : hDDEData;
var
  hszpTemp : tHSZPair;
var
  TopicTemp,
  ItemTemp : Array[0..50] of Char;
begin
  DDEQueryString(idInst, hsz1, @TopicTemp, Sizeof(TopicTemp), CP_WINANSI);
  DDEQueryString(idInst, hsz2, @ItemTemp, Sizeof(ItemTemp), CP_WINANSI);
  hszpTemp.hszSvc := 0;
  hszpTemp.hszTopic := 0;
  WildConnect := 0;
  if (hsz1 = 0) AND (hsz2 = 0) then
  begin
    WildConnect := DDECreateDataHandle(idInst, @hszpTemp, Sizeof(hszpTemp), 0, 0, wFmt, 0);
  end;
  if (hsz1 = 0) AND (DDECmpStringHandles(hsz2, hszService) = 0) then
  begin
    WildConnect := DDECreateDataHandle(idInst, @hszpTemp, Sizeof(hszpTemp), 0, 0, wFmt, 0);
  end;
  if (DDECmpStringHandles(hsz1, hszTopic) = 0) AND (hsz2 = 0) then
  begin
    WildConnect := DDECreateDataHandle(idInst, @hszpTemp, Sizeof(hszpTemp), 0, 0, wFmt, 0);
  end;
end;


Function TNDDESrWnd.DataRequested(wFmt : Word) : hDDEData;
const
  iLoop : Integer = 0;

  szItems : Array[0..8] of PChar = ('Borland C++',
                                    'Turbo C++',
                                    'Borland Pascal with Objects',
                                    'Turbo Pascal',
                                    'Objectvision',
                                    'Paradox',
                                    'dBase',
                                    'Quattro Pro',
                                    'Brief');
begin
  DataRequested := 0;
  if (wFmt = CF_TEXT) then
  begin
    inc(iLoop);
    if iLoop > 8 then iLoop := 0;
    DataRequested := DDECreateDataHandle(idInst, szItems[iLoop], StrLen(szItems[iLoop]) + 1, 0, hszItem, wFmt, 0);
  end;
end;

Procedure TNDDESrWnd.UpdateData;
begin
  DDEPostAdvise(idInst, hszShare, hszItem);
end;

Type
{ TNDDESrApp }

  PNDDESrApp = ^TNDDESrApp;
  TNDDESrApp = object(TApplication)
    Constructor Init(AName : PChar);
    Procedure InitMainWindow; virtual;
    Function IdleAction : Boolean; virtual;
  private
    dwTime : LongInt;
  end;

Constructor TNDDESrApp.Init(AName : PChar);
begin
  inherited init(AName);
  dwTime := GetTickCount;
end;

Procedure TNDDESrApp.InitMainWindow;
begin
  MainWindow := New (PNDDESrWnd, init(NIL, 'NDDESVR. (A Network DDE Server)'));
  ConvWindow := PNDDESrWnd(MainWindow);
end;

Function TNDDESrApp.IdleAction : Boolean;
begin
  if (MainWindow <> NIL) AND (PNDDESrWnd(MainWindow)^.tfLoop = TRUE) then
  begin
      PNDDESrWnd(MainWindow)^.UpdateData;
  end;
  IdleAction := inherited IdleAction;
end;

{ Main Loop }

Var
  ANDDEApp : TNDDESrApp;

begin
  CmdShow := SW_ShowMinimized;
  With ANDDEApp do
  begin
    Init('Network DDE Server App');
    Run;
    Done;
  end;
end.